/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui;

import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import openmods.api.IValueProvider;
import openmods.api.IValueReceiver;
import openmods.container.ContainerBase;
import openmods.gui.SyncedGuiContainer;
import openmods.gui.component.BaseComposite;
import openmods.gui.component.GuiComponentCheckbox;
import openmods.gui.component.GuiComponentLabel;
import openmods.gui.component.GuiComponentSideSelector;
import openmods.gui.component.GuiComponentTab;
import openmods.gui.component.GuiComponentTabWrapper;
import openmods.gui.listener.IValueChangedListener;
import openmods.gui.logic.ValueCopyAction;
import openmods.gui.misc.IConfigurableGuiSlots;
import openmods.utils.bitmap.IWriteableBitMap;

public abstract class GuiConfigurableSlots<T extends TileEntity & IConfigurableGuiSlots<E>, C extends ContainerBase<T>, E extends Enum<E>>
extends SyncedGuiContainer<C> {
    public GuiConfigurableSlots(C container, int width, int height, String name) {
        super(container, width, height, name);
    }

    protected abstract Iterable<E> getSlots();

    protected abstract void addCustomizations(BaseComposite var1);

    protected abstract GuiComponentTab createTab(E var1);

    protected GuiComponentSideSelector createSideSelector(E slot, IBlockState state, T te) {
        return new GuiComponentSideSelector(15, 15, 40.0, state, (TileEntity)te, true);
    }

    protected GuiComponentCheckbox createCheckbox(E slot) {
        return new GuiComponentCheckbox(10, 82, false);
    }

    protected abstract GuiComponentLabel createLabel(E var1);

    @Override
    protected final BaseComposite createRoot() {
        TileEntity te = (TileEntity)((ContainerBase)((Object)this.getContainer())).getOwner();
        IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
        BaseComposite main = super.createRoot();
        this.addCustomizations(main);
        GuiComponentTabWrapper tabs = new GuiComponentTabWrapper(0, 0, main);
        for (Enum slot : this.getSlots()) {
            GuiComponentTab tabTool = this.createTab(slot);
            tabs.addComponent(tabTool);
            GuiComponentSideSelector sideSelector = this.createSideSelector(slot, state, te);
            GuiComponentCheckbox checkbox = this.createCheckbox(slot);
            this.setupCheckBox(checkbox, ((IConfigurableGuiSlots)te).createAutoFlagProvider(slot), ((IConfigurableGuiSlots)te).createAutoSlotReceiver(slot));
            this.setupSelector(sideSelector, ((IConfigurableGuiSlots)te).createAllowedDirectionsProvider(slot), ((IConfigurableGuiSlots)te).createAllowedDirectionsReceiver(slot));
            tabTool.addComponent(sideSelector);
            tabTool.addComponent(checkbox);
            tabTool.addComponent(this.createLabel(slot));
        }
        return tabs;
    }

    private void setupSelector(GuiComponentSideSelector selector, IValueProvider<Set<EnumFacing>> source, final IWriteableBitMap<EnumFacing> updater) {
        selector.setListener(new GuiComponentSideSelector.ISideSelectedListener(){

            @Override
            public void onSideToggled(EnumFacing side, boolean currentState) {
                updater.set(side, currentState);
            }
        });
        this.addSyncUpdateListener(ValueCopyAction.create(source, selector));
    }

    private void setupCheckBox(GuiComponentCheckbox checkbox, IValueProvider<Boolean> source, final IValueReceiver<Boolean> updater) {
        checkbox.setListener(new IValueChangedListener<Boolean>(){

            @Override
            public void valueChanged(Boolean value) {
                updater.setValue(value);
            }
        });
        this.addSyncUpdateListener(ValueCopyAction.create(source, checkbox));
    }
}

