/*
 * Decompiled with CFR 0.152.
 */
package openmods.geometry;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import openmods.Log;
import openmods.geometry.Hitbox;
import openmods.geometry.IHitboxSupplier;

public class HitboxManager
implements IResourceManagerReloadListener {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Vec3d.class, (Object)new JsonDeserializer<Vec3d>(){

        public Vec3d deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonArray jsonarray = JsonUtils.func_151207_m((JsonElement)json, (String)"vector");
            if (jsonarray.size() != 3) {
                throw new JsonParseException("Expected 3 float values, found: " + jsonarray.size());
            }
            float[] coords = new float[3];
            for (int i = 0; i < 3; ++i) {
                coords[i] = JsonUtils.func_151220_d((JsonElement)jsonarray.get(i), (String)("[" + i + "]")) / 16.0f;
            }
            return new Vec3d((double)coords[0], (double)coords[1], (double)coords[2]);
        }
    }).create();
    private IResourceManager resourceManager;
    private final Map<ResourceLocation, Holder> holders = Maps.newHashMap();

    private List<Hitbox> load(ResourceLocation location) {
        ArrayList result = Lists.newArrayList();
        if (this.resourceManager != null) {
            try {
                IResource resource = this.resourceManager.func_110536_a(location);
                Closer closer = Closer.create();
                try {
                    InputStream is = (InputStream)closer.register((Closeable)resource.func_110527_b());
                    Reader reader = (Reader)closer.register((Closeable)new InputStreamReader(is, Charsets.UTF_8));
                    HitboxList list = (HitboxList)GSON.fromJson(reader, HitboxList.class);
                    result.addAll(list);
                }
                catch (Throwable t) {
                    throw closer.rethrow(t);
                }
                finally {
                    closer.close();
                }
            }
            catch (IOException e) {
                Log.warn(e, "Failed to find hitbox %s", location);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHitboxSupplier get(ResourceLocation location) {
        Map<ResourceLocation, Holder> map = this.holders;
        synchronized (map) {
            Holder result = this.holders.get(location);
            if (result == null) {
                result = new Holder(location);
                this.holders.put(location, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_110549_a(IResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        if (resourceManager != null) {
            Map<ResourceLocation, Holder> map = this.holders;
            synchronized (map) {
                for (Holder holder : this.holders.values()) {
                    holder.reload();
                }
            }
        }
    }

    private class Holder
    implements IHitboxSupplier {
        private final ResourceLocation location;
        private List<Hitbox> list;
        private Map<String, Hitbox> map;

        public Holder(ResourceLocation location) {
            this.location = new ResourceLocation(location.func_110624_b(), "hitboxes/" + location.func_110623_a() + ".json");
        }

        private void reload() {
            this.list = ImmutableList.copyOf((Collection)HitboxManager.this.load(this.location));
            LinkedHashMap builder = Maps.newLinkedHashMap();
            for (Hitbox hb : this.list) {
                builder.put(hb.name, hb);
            }
            this.map = ImmutableMap.copyOf((Map)builder);
        }

        @Override
        public List<Hitbox> asList() {
            if (this.list == null) {
                this.reload();
            }
            return this.list;
        }

        @Override
        public Map<String, Hitbox> asMap() {
            if (this.map == null) {
                this.reload();
            }
            return this.map;
        }
    }

    private static class HitboxList
    extends ArrayList<Hitbox> {
        private HitboxList() {
        }
    }
}

