/*
 * Decompiled with CFR 0.152.
 */
package openmods.geometry;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.util.EnumFacing;
import org.apache.commons.lang3.tuple.Pair;

public class FaceClassifier {
    private static final Map<EnumFacing, Vector3f> BASES = Maps.newEnumMap(EnumFacing.class);
    private final List<Pair<Vector3f, EnumFacing>> sideOrder = Lists.newArrayList();

    public FaceClassifier(Collection<EnumFacing> sideOrder) {
        this.sideOrder.addAll(Collections2.transform(sideOrder, (Function)new Function<EnumFacing, Pair<Vector3f, EnumFacing>>(){

            public Pair<Vector3f, EnumFacing> apply(EnumFacing input) {
                return Pair.of(BASES.get(input), (Object)input);
            }
        }));
    }

    public Optional<EnumFacing> classify(Vector3f normalVec) {
        for (Pair<Vector3f, EnumFacing> e : this.sideOrder) {
            Vector3f base = (Vector3f)e.getKey();
            if (normalVec.equals((Tuple3f)base)) {
                return Optional.of((Object)e.getValue());
            }
            double angleCos = base.dot(normalVec);
            if (!(angleCos > 0.0)) continue;
            return Optional.of((Object)e.getValue());
        }
        return Optional.absent();
    }

    static {
        for (EnumFacing e : EnumFacing.field_82609_l) {
            BASES.put(e, new Vector3f((float)e.func_82601_c(), (float)e.func_96559_d(), (float)e.func_82599_e()));
        }
    }
}

