/*
 * Decompiled with CFR 0.152.
 */
package openmods.fakeplayer;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import openmods.Log;

public class OpenModsFakePlayer
extends FakePlayer {
    OpenModsFakePlayer(WorldServer worldObj, int id) {
        super(worldObj, OpenModsFakePlayer.createProfile(String.format("OpenModsFakethis-%03d", id)));
        GameProfile profile = this.func_146103_bH();
        Log.debug("Creating new fake this: name = %s, id = %s", profile.getName(), profile.getId());
    }

    private static GameProfile createProfile(String name) {
        UUID uuid = UUID.nameUUIDFromBytes(name.getBytes());
        return new GameProfile(uuid, name);
    }

    public void func_70106_y() {
        this.field_71071_by.func_174888_l();
        this.field_70128_L = true;
    }

    public EnumActionResult rightClick(ItemStack itemStack, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (itemStack == null) {
            return EnumActionResult.PASS;
        }
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((EntityPlayer)this, (EnumHand)hand, (ItemStack)itemStack, (BlockPos)pos, (EnumFacing)facing, (Vec3d)new Vec3d((double)hitX, (double)hitY, (double)hitZ));
        if (event.isCanceled()) {
            return EnumActionResult.PASS;
        }
        Item usedItem = itemStack.func_77973_b();
        EnumActionResult firstUseResult = usedItem.onItemUseFirst(itemStack, (EntityPlayer)this, this.field_70170_p, pos, facing, hitX, hitY, hitZ, hand);
        if (firstUseResult != EnumActionResult.PASS) {
            return firstUseResult;
        }
        boolean bypass = itemStack.func_77973_b().doesSneakBypassUse(itemStack, (IBlockAccess)this.field_70170_p, pos, (EntityPlayer)this);
        EnumActionResult result = EnumActionResult.PASS;
        if (!this.func_70093_af() || bypass || event.getUseBlock() == Event.Result.ALLOW) {
            IBlockState iblockstate = this.field_70170_p.func_180495_p(pos);
            if (event.getUseBlock() != Event.Result.DENY) {
                try {
                    if (iblockstate.func_177230_c().func_180639_a(this.field_70170_p, pos, iblockstate, (EntityPlayer)this, hand, itemStack, facing, hitX, hitY, hitZ)) {
                        result = EnumActionResult.SUCCESS;
                    }
                }
                catch (Throwable t) {
                    Log.warn(t, "Invalid use of fake player on block %s @ (%s), aborting. Don't do it again", iblockstate, pos);
                }
            }
        }
        if (result != EnumActionResult.SUCCESS && event.getUseItem() != Event.Result.DENY || result == EnumActionResult.SUCCESS && event.getUseItem() == Event.Result.ALLOW) {
            try {
                return itemStack.func_179546_a((EntityPlayer)this, this.field_70170_p, pos, hand, facing, hitX, hitY, hitZ);
            }
            catch (Throwable t) {
                Log.warn(t, "Invalid use of fake player with item %s @ (%s), aborting. Don't do it again", usedItem, pos);
                return EnumActionResult.PASS;
            }
        }
        return result;
    }
}

