/*
 * Decompiled with CFR 0.152.
 */
package openmods.core;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import openmods.Log;
import openmods.api.IResultListener;
import openmods.asm.TransformerState;
import openmods.asm.VisitorHelper;
import openmods.config.simple.ConfigProcessor;
import openmods.core.fixes.HorseNullFix;
import openmods.entity.PlayerDamageEventInjector;
import openmods.include.IncludingClassVisitor;
import openmods.movement.MovementPatcher;
import openmods.renderer.PlayerRendererHookVisitor;
import openmods.renderer.PreWorldRenderHookVisitor;
import openmods.utils.StateTracker;
import openmods.world.MapGenStructureVisitor;
import org.objectweb.asm.ClassVisitor;

public class OpenModsClassTransformer
implements IClassTransformer {
    private static OpenModsClassTransformer INSTANCE;
    private static final List<String> IGNORED_PREFIXES;
    private final Map<String, VisitorHelper.TransformProvider> vanillaPatches = Maps.newHashMap();
    private final StateTracker<TransformerState> states = StateTracker.create(TransformerState.DISABLED);
    private Set<String> includedClasses;
    private static final VisitorHelper.TransformProvider INCLUDING_CV;

    private static IResultListener createResultListener(final StateTracker.StateUpdater<TransformerState> updater) {
        return new IResultListener(){

            @Override
            public void onSuccess() {
                updater.update(TransformerState.FINISHED);
            }

            @Override
            public void onFailure() {
                updater.update(TransformerState.FAILED);
            }
        };
    }

    public OpenModsClassTransformer() {
        INSTANCE = this;
    }

    public static OpenModsClassTransformer instance() {
        return INSTANCE;
    }

    public void addConfigValues(ConfigProcessor config) {
        config.addEntry("activate_movement_callback", 0, "true", new ConfigOption("movement_callback"){

            @Override
            protected void onActivate(final StateTracker.StateUpdater<TransformerState> state) {
                OpenModsClassTransformer.this.vanillaPatches.put("net.minecraft.client.entity.EntityPlayerSP", new VisitorHelper.TransformProvider(2){

                    @Override
                    public ClassVisitor createVisitor(String name, ClassVisitor cv) {
                        Log.debug("Trying to apply movement callback (class: %s)", name);
                        state.update(TransformerState.ACTIVATED);
                        return new MovementPatcher(name, cv, OpenModsClassTransformer.createResultListener(state));
                    }
                });
            }
        }, "Purpose: this transformer add hook to player movement controls", "Modified class: net.minecraft.client.entity.EntityPlayerSP", "Known users: OpenBlocks elevator", "When disabled: users usually have fallbacks (elevator will use less accurate algorithm)");
        config.addEntry("activate_map_gen_fix", 0, "true", new ConfigOption("map_gen_fix"){

            @Override
            protected void onActivate(final StateTracker.StateUpdater<TransformerState> state) {
                OpenModsClassTransformer.this.vanillaPatches.put("net.minecraft.world.gen.structure.MapGenStructure", new VisitorHelper.TransformProvider(2){

                    @Override
                    public ClassVisitor createVisitor(String name, ClassVisitor cv) {
                        Log.debug("Trying to patch MapGenStructure (class: %s)", name);
                        state.update(TransformerState.ACTIVATED);
                        return new MapGenStructureVisitor(name, cv, OpenModsClassTransformer.createResultListener(state));
                    }
                });
            }
        }, "Purpose: fix bug in vanilla code used to find nearby structures", "Modified class: net.minecraft.world.gen.structure.MapGenStructure", "Known users: OpenBlocks golden eye", "When disabled: features may not work (either silently fail or cause crash)");
        config.addEntry("activate_player_render_hook", 0, "true", new ConfigOption("player_render_hook"){

            @Override
            protected void onActivate(final StateTracker.StateUpdater<TransformerState> state) {
                OpenModsClassTransformer.this.vanillaPatches.put("net.minecraft.client.renderer.entity.RenderPlayer", new VisitorHelper.TransformProvider(2){

                    @Override
                    public ClassVisitor createVisitor(String name, ClassVisitor cv) {
                        Log.debug("Trying to apply player render hook (class: %s)", name);
                        state.update(TransformerState.ACTIVATED);
                        return new PlayerRendererHookVisitor(name, cv, OpenModsClassTransformer.createResultListener(state));
                    }
                });
            }
        }, "Purpose: add hook to player rendering code", "Modified class: net.minecraft.client.renderer.entity.RenderPlayer", "Known users: OpenBlocks hangglider", "When disabled: code may fallback to less compatible mechanism (like replacing renderer)");
        config.addEntry("activate_player_damage_hook", 0, "true", new ConfigOption("player_damage_hook"){

            @Override
            protected void onActivate(final StateTracker.StateUpdater<TransformerState> state) {
                OpenModsClassTransformer.this.vanillaPatches.put("net.minecraft.entity.player.EntityPlayer", new VisitorHelper.TransformProvider(2){

                    @Override
                    public ClassVisitor createVisitor(String name, ClassVisitor cv) {
                        Log.debug("Trying to patch EntityPlayer (class: %s)", name);
                        state.update(TransformerState.ACTIVATED);
                        return new PlayerDamageEventInjector(name, cv, OpenModsClassTransformer.createResultListener(state));
                    }
                });
            }
        }, "Purpose: hook for capturing damage to player (after armor and potion calculations)", "Modified class: net.minecraft.entity.player.EntityPlayer", "Known users: Last Stand enchantment", "When disabled: Last Stand enchantment will not work");
        config.addEntry("hook_pre_world_rendering", 0, "true", new ConfigOption("pre_world_render_hook"){

            @Override
            protected void onActivate(final StateTracker.StateUpdater<TransformerState> state) {
                OpenModsClassTransformer.this.vanillaPatches.put("net.minecraft.client.renderer.EntityRenderer", new VisitorHelper.TransformProvider(0){

                    @Override
                    public ClassVisitor createVisitor(String name, ClassVisitor cv) {
                        Log.debug("Trying to patch EntityRenderer (class: %s)", name);
                        state.update(TransformerState.ACTIVATED);
                        return new PreWorldRenderHookVisitor(name, cv, OpenModsClassTransformer.createResultListener(state));
                    }
                });
            }
        }, "Purpose: hook in world rendering, triggered between sky and terrain", "Modified class: net.minecraft.client.renderer.EntityRenderer", "Known users: Sky block", "When disabled: Sky block will not render properly");
        config.addEntry("horse_null_fix", 0, "true", new ConfigOption("horse_null_fix"){

            @Override
            protected void onActivate(final StateTracker.StateUpdater<TransformerState> state) {
                OpenModsClassTransformer.this.vanillaPatches.put("net.minecraft.entity.passive.EntityHorse", new VisitorHelper.TransformProvider(0){

                    @Override
                    public ClassVisitor createVisitor(String name, ClassVisitor cv) {
                        Log.debug("Trying to patch EntityHorse (class: %s)", name);
                        state.update(TransformerState.ACTIVATED);
                        return new HorseNullFix(name, cv, OpenModsClassTransformer.createResultListener(state));
                    }
                });
            }
        }, "Purpose: prevent NPE when creating horse without world", "Modified class: net.minecraft.entity.passive.EntityHorse", "Known users: Trophy", "When disabled: Horse trophy cannot be rendered");
    }

    public void injectAsmData(ASMDataTable table) {
        ImmutableSet.Builder includedClasses = ImmutableSet.builder();
        for (ASMDataTable.ASMData data : table.getAll("openmods.include.IncludeInterface")) {
            includedClasses.add((Object)data.getClassName());
        }
        for (ASMDataTable.ASMData data : table.getAll("openmods.include.IncludeOverride")) {
            includedClasses.add((Object)data.getClassName());
        }
        this.includedClasses = includedClasses.build();
    }

    private boolean shouldTryIncluding(String clsName) {
        if (this.includedClasses != null) {
            return this.includedClasses.contains(clsName);
        }
        for (String prefix : IGNORED_PREFIXES) {
            if (!clsName.startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (transformedName.startsWith("net.minecraft.")) {
            VisitorHelper.TransformProvider provider = this.vanillaPatches.get(transformedName);
            return provider != null ? VisitorHelper.apply(bytes, name, provider) : bytes;
        }
        if (this.shouldTryIncluding(transformedName)) {
            return this.applyIncludes(name, transformedName, bytes);
        }
        return bytes;
    }

    protected byte[] applyIncludes(String name, String transformedName, byte[] bytes) {
        try {
            return VisitorHelper.apply(bytes, name, INCLUDING_CV);
        }
        catch (Throwable t) {
            Log.severe(t, "Failed to apply including transformer on %s(%s)", name, transformedName);
            throw Throwables.propagate((Throwable)t);
        }
    }

    public String listStates() {
        return Joiner.on((char)',').join(Iterables.transform(this.states.states(), (Function)Functions.toStringFunction()));
    }

    static {
        IGNORED_PREFIXES = ImmutableList.of((Object)"cpw.mods.fml.", (Object)"net.minecraftforge.", (Object)"io.netty.", (Object)"gnu.trove.", (Object)"com.google.", (Object)"com.mojang.", (Object)"joptsimple.", (Object)"tv.twitch.");
        INCLUDING_CV = new VisitorHelper.TransformProvider(0){

            @Override
            public ClassVisitor createVisitor(String name, ClassVisitor cv) {
                return new IncludingClassVisitor(cv);
            }
        };
    }

    private abstract class ConfigOption
    implements ConfigProcessor.UpdateListener {
        private final StateTracker.StateUpdater<TransformerState> state;

        public ConfigOption(String name) {
            this.state = OpenModsClassTransformer.this.states.register(name);
        }

        @Override
        public void valueSet(String value) {
            if ("true".equalsIgnoreCase(value)) {
                this.state.update(TransformerState.ENABLED);
                this.onActivate(this.state);
            }
        }

        protected abstract void onActivate(StateTracker.StateUpdater<TransformerState> var1);
    }
}

