/*
 * Decompiled with CFR 0.152.
 */
package openmods.colors;

import com.google.common.base.Preconditions;
import openmods.colors.ColorMeta;
import openmods.colors.RGB;

public class ColorUtils {
    public static int bitmaskToVanilla(int color) {
        int low;
        int high = Integer.numberOfLeadingZeros(color);
        Preconditions.checkArgument((high == 31 - (low = Integer.numberOfTrailingZeros(color)) && low <= 16 ? 1 : 0) != 0, (String)"Invalid color value: %sb", (Object[])new Object[]{Integer.toBinaryString(color)});
        return low;
    }

    public static ColorMeta findNearestColor(RGB target, int tolernace) {
        ColorMeta result = null;
        int distSq = Integer.MAX_VALUE;
        for (ColorMeta meta : ColorMeta.VALUES) {
            int currentDistSq = meta.rgbWrap.distance(target);
            if (currentDistSq >= distSq) continue;
            result = meta;
            distSq = currentDistSq;
        }
        return distSq < 3 * tolernace * tolernace ? result : null;
    }
}

