/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import info.openmods.calc.types.multi.Cons;
import info.openmods.calc.types.multi.StructWrapper;
import info.openmods.calc.types.multi.TypedValue;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import openmods.utils.EnchantmentUtils;

public class EntityPlayerWrapper {
    private final WeakReference<EntityPlayer> player;
    private final TypedValue nullValue;

    public EntityPlayerWrapper(EntityPlayer player, TypedValue nullValue) {
        this.player = new WeakReference<EntityPlayer>(player);
        this.nullValue = nullValue;
    }

    @StructWrapper.ExposeProperty
    public Boolean isValid() {
        return this.player.get() != null;
    }

    private EntityPlayer player() {
        EntityPlayer player = (EntityPlayer)this.player.get();
        Preconditions.checkNotNull((Object)player, (Object)"Object no longer valid");
        return player;
    }

    @StructWrapper.ExposeProperty
    public String name() {
        return this.player().func_146103_bH().getName();
    }

    @StructWrapper.ExposeProperty
    public String uuid() {
        return this.player().func_146103_bH().getId().toString();
    }

    @StructWrapper.ExposeProperty
    public Double hp() {
        return this.player().func_110143_aJ();
    }

    @StructWrapper.ExposeProperty
    public BigInteger xp() {
        return BigInteger.valueOf(EnchantmentUtils.getPlayerXP(this.player()));
    }

    @StructWrapper.ExposeProperty
    public BigInteger level() {
        return BigInteger.valueOf(this.player().field_71068_ca);
    }

    @StructWrapper.ExposeProperty
    public Double xpBar() {
        return this.player().field_71106_cc;
    }

    @StructWrapper.ExposeProperty
    public Double x() {
        return this.player().field_70165_t;
    }

    @StructWrapper.ExposeProperty
    public Double y() {
        return this.player().field_70165_t;
    }

    @StructWrapper.ExposeProperty
    public Double z() {
        return this.player().field_70165_t;
    }

    @StructWrapper.ExposeProperty
    public Double vx() {
        return this.player().field_70159_w;
    }

    @StructWrapper.ExposeProperty
    public Double vy() {
        return this.player().field_70181_x;
    }

    @StructWrapper.ExposeProperty
    public Double vz() {
        return this.player().field_70179_y;
    }

    @StructWrapper.ExposeProperty
    public Double yaw() {
        return this.player().field_70177_z;
    }

    @StructWrapper.ExposeProperty
    public Double pitch() {
        return this.player().field_70125_A;
    }

    @StructWrapper.ExposeProperty
    public Boolean creative() {
        return this.player().field_71075_bZ.field_75098_d;
    }

    @StructWrapper.ExposeProperty
    public Boolean flying() {
        return this.player().field_71075_bZ.field_75100_b;
    }

    @StructWrapper.ExposeProperty
    public Boolean inAir() {
        return this.player().field_70160_al;
    }

    @StructWrapper.ExposeProperty
    public Boolean burning() {
        return this.player().func_70027_ad();
    }

    @StructWrapper.ExposeProperty
    public StructWrapper world() {
        return StructWrapper.create(new WorldWrapper(this.player().func_130014_f_()));
    }

    @StructWrapper.ExposeProperty
    public BigInteger inventorySize() {
        return BigInteger.valueOf(this.player().field_71071_by.func_70302_i_());
    }

    @StructWrapper.ExposeMethod
    public StructWrapper inventoryItem(BigInteger slotId) {
        InventoryPlayer inventory = this.player().field_71071_by;
        int slot = slotId.intValue();
        Preconditions.checkState((slot >= 0 && slot < inventory.func_70302_i_() ? 1 : 0) != 0, (Object)"Invalid slot");
        return StructWrapper.create(new ItemStackWrapper(inventory.func_70301_a(slot)));
    }

    @StructWrapper.ExposeProperty
    public StructWrapper currentItem() {
        InventoryPlayer inventory = this.player().field_71071_by;
        return StructWrapper.create(new ItemStackWrapper(inventory.func_70448_g()));
    }

    public class ItemStackWrapper {
        private final ItemStack itemStack;

        public ItemStackWrapper(ItemStack itemStack) {
            this.itemStack = itemStack;
        }

        @StructWrapper.ExposeProperty
        public BigInteger count() {
            return BigInteger.valueOf(this.itemStack.field_77994_a);
        }

        @StructWrapper.ExposeProperty
        public BigInteger damage() {
            return BigInteger.valueOf(this.itemStack.func_77952_i());
        }

        @StructWrapper.ExposeProperty
        public String name() {
            return this.itemStack.func_77977_a();
        }

        @StructWrapper.ExposeProperty
        public String displayName() {
            return this.itemStack.func_82833_r();
        }

        @StructWrapper.ExposeProperty(raw=true)
        public TypedValue enchantments() {
            ArrayList result = Lists.newArrayList();
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)this.itemStack);
            for (Map.Entry e : enchantments.entrySet()) {
                if (e.getKey() == null) continue;
                result.add(StructWrapper.create(((EntityPlayerWrapper)EntityPlayerWrapper.this).nullValue.domain, new EnchantmentWrapper((Enchantment)e.getKey(), (Integer)e.getValue())));
            }
            return Cons.createList(result, EntityPlayerWrapper.this.nullValue);
        }
    }

    public static class EnchantmentWrapper {
        private final Enchantment ench;
        @StructWrapper.ExposeProperty
        public final BigInteger level;

        public EnchantmentWrapper(Enchantment ench, int level) {
            this.ench = ench;
            this.level = BigInteger.valueOf(level);
        }

        @StructWrapper.ExposeProperty
        public String name() {
            return this.ench.func_77320_a();
        }
    }

    public static class WorldWrapper {
        private final WeakReference<World> world;

        public WorldWrapper(World world) {
            this.world = new WeakReference<World>(world);
        }

        public World world() {
            World world = (World)this.world.get();
            Preconditions.checkNotNull((Object)world, (Object)"Object no longer valid");
            return world;
        }

        @StructWrapper.ExposeProperty
        public String name() {
            return this.world().func_72912_H().func_76065_j();
        }

        @StructWrapper.ExposeProperty
        public String type() {
            return this.world().func_72827_u();
        }

        @StructWrapper.ExposeProperty
        public BigInteger dimension() {
            return BigInteger.valueOf(this.world().field_73011_w.getDimension());
        }

        @StructWrapper.ExposeProperty
        public BigInteger totalTime() {
            return BigInteger.valueOf(this.world().func_82737_E());
        }

        @StructWrapper.ExposeProperty
        public BigInteger time() {
            return BigInteger.valueOf(this.world().func_72820_D());
        }
    }
}

