/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.utils.reflection;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import info.openmods.calc.utils.reflection.TypeVariableHolder;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public class TypeVariableHolderFiller {
    public static final TypeVariableHolderFiller instance = new TypeVariableHolderFiller();
    private final Map<Class<?>, Map<String, TypeVariable<?>>> sourceCache = Maps.newHashMap();

    private TypeVariableHolderFiller() {
    }

    public void initialize(Class<?> targetClass) {
        HashMap targetToSource = Maps.newHashMap();
        TypeVariableHolderFiller.fillHolders(targetClass, targetToSource);
        for (Class<?> inner : targetClass.getDeclaredClasses()) {
            TypeVariableHolderFiller.fillHolders(inner, targetToSource);
        }
        this.fillFields(targetToSource);
    }

    private static void fillHolders(Class<?> targetClass, Map<Field, Class<?>> targetToSource) {
        Field[] fields = targetClass.getDeclaredFields();
        TypeVariableHolder clsAnnotation = targetClass.getAnnotation(TypeVariableHolder.class);
        if (clsAnnotation != null) {
            Class<?> sourceClass = TypeVariableHolderFiller.findSourceClass(clsAnnotation, targetClass);
            Field[] fieldArray = fields;
            int n = fieldArray.length;
            for (int i = 0; i < n; ++i) {
                Field f = fieldArray[i];
                if (!TypeVariableHolderFiller.isValidField(f)) continue;
                targetToSource.put(f, sourceClass);
            }
        }
        for (Field f : fields) {
            TypeVariableHolder fieldAnnotation = f.getAnnotation(TypeVariableHolder.class);
            if (fieldAnnotation == null) continue;
            Preconditions.checkArgument((boolean)TypeVariableHolderFiller.isValidField(f), (String)"Field %s marked with TypeVariableHolder annotation must be static, non-final and have TypeVariable type", (Object[])new Object[]{f});
            Class<?> sourceClass = TypeVariableHolderFiller.findSourceClass(fieldAnnotation, targetClass);
            targetToSource.put(f, sourceClass);
        }
    }

    private static Class<?> findSourceClass(TypeVariableHolder annotation, Class<?> targetClass) {
        if (annotation.value() == TypeVariableHolder.UseDeclaringType.class) {
            return targetClass;
        }
        return annotation.value();
    }

    private static boolean isValidField(Field field) {
        int modifiers = field.getModifiers();
        return field.getType() == TypeVariable.class && Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers);
    }

    private void fillFields(Map<Field, Class<?>> fieldTargetToSource) {
        for (Map.Entry<Field, Class<?>> e : fieldTargetToSource.entrySet()) {
            this.fillField(e.getKey(), e.getValue());
        }
    }

    private void fillField(Field targetField, Class<?> sourceClass) {
        try {
            Map<String, TypeVariable<?>> sourceVariables = this.getSourceTypeVariables(sourceClass);
            String variableName = targetField.getName();
            TypeVariable<?> sourceTypeVariable = sourceVariables.get(variableName);
            Preconditions.checkState((sourceTypeVariable != null ? 1 : 0) != 0, (String)"Can't find type variable '%s' in class '%s", (Object[])new Object[]{variableName, sourceClass});
            targetField.setAccessible(true);
            targetField.set(null, sourceTypeVariable);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Map<String, TypeVariable<?>> getSourceTypeVariables(Class<?> sourceClass) {
        HashMap result = this.sourceCache.get(sourceClass);
        if (result == null) {
            result = Maps.newHashMap();
            for (TypeVariable<Class<?>> t : sourceClass.getTypeParameters()) {
                result.put(t.getName(), t);
            }
            this.sourceCache.put(sourceClass, result);
        }
        return result;
    }
}

