/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.utils;

public abstract class OptionalInt {
    private static final int CACHE_RANGE = 16;
    private static final OptionalInt[] cache = new OptionalInt[33];
    public static final OptionalInt ABSENT = new Absent();
    public static final OptionalInt ZERO;
    public static final OptionalInt ONE;
    public static final OptionalInt TWO;

    private OptionalInt() {
    }

    public abstract boolean isPresent();

    public abstract int get();

    public abstract int or(int var1);

    public abstract boolean compareIfPresent(int var1);

    public abstract OptionalInt map(IntFunction var1);

    public static OptionalInt of(int value) {
        if (Math.abs(value) <= 16) {
            return cache[value + 16];
        }
        return new Present(value);
    }

    public static OptionalInt fromNullable(Integer value) {
        if (value == null) {
            return ABSENT;
        }
        return OptionalInt.of(value);
    }

    public static OptionalInt absent() {
        return ABSENT;
    }

    static {
        for (int i = 0; i < 33; ++i) {
            OptionalInt.cache[i] = new Present(i - 16);
        }
        ZERO = OptionalInt.of(0);
        ONE = OptionalInt.of(1);
        TWO = OptionalInt.of(2);
    }

    public static interface IntFunction {
        public int apply(int var1);
    }

    private static class Absent
    extends OptionalInt {
        private Absent() {
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public int get() {
            throw new IllegalStateException("No value");
        }

        @Override
        public int or(int defaultValue) {
            return defaultValue;
        }

        @Override
        public boolean compareIfPresent(int value) {
            return true;
        }

        public String toString() {
            return "absent";
        }

        @Override
        public OptionalInt map(IntFunction function) {
            return this;
        }
    }

    private static class Present
    extends OptionalInt {
        private final int value;

        public Present(int value) {
            this.value = value;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public int get() {
            return this.value;
        }

        @Override
        public int or(int defaultValue) {
            return this.value;
        }

        @Override
        public boolean compareIfPresent(int value) {
            return value == this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.value;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Present) {
                Present other = (Present)obj;
                return this.value == other.value;
            }
            return false;
        }

        public String toString() {
            return "present: " + this.value;
        }

        @Override
        public OptionalInt map(IntFunction function) {
            return new Present(function.apply(this.value));
        }
    }
}

