/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.multi;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import info.openmods.calc.types.multi.MetaObject;
import info.openmods.calc.types.multi.TypeDomain;

public class TypedValue {
    public final TypeDomain domain;
    public final Class<?> type;
    public final Object value;
    private Optional<MetaObject> metaObject;

    TypedValue(TypeDomain domain, Class<?> type, Object value) {
        Preconditions.checkArgument((boolean)type.isInstance(value), (String)"Value '%s' is not instance of '%s'", (Object[])new Object[]{value, type});
        this.domain = domain;
        this.type = type;
        this.value = value;
        this.metaObject = Optional.absent();
    }

    TypedValue(TypeDomain domain, Class<?> type, Object value, MetaObject metaObject) {
        Preconditions.checkArgument((boolean)type.isInstance(value), (String)"Value '%s' is not instance of '%s'", (Object[])new Object[]{value, type});
        this.domain = domain;
        this.type = type;
        this.value = value;
        this.metaObject = Optional.of((Object)metaObject);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TypedValue) {
            TypedValue other = (TypedValue)obj;
            return this.domain == other.domain && this.type == other.type && Objects.equal((Object)this.value, (Object)other.value);
        }
        return false;
    }

    public String typeStr() {
        return this.domain.getName(this.type);
    }

    public String toString() {
        return "[" + this.typeStr() + ":" + this.value + "]";
    }

    public TypedValue cast(Class<?> type) {
        return this.domain.convert(this, type);
    }

    public <T> T unwrap(Class<T> type) {
        return this.domain.unwrap(this, type);
    }

    private String getClassName(Class<?> cls) {
        Optional<String> name = this.domain.tryGetName(cls);
        return name.isPresent() ? (String)name.get() : cls.getSimpleName();
    }

    private ClassCastException castException(Class<?> expectedType) {
        return new ClassCastException(String.format("Expected '%s', got %s", this.getClassName(expectedType), this));
    }

    private ClassCastException castException(Class<?> expectedType, String location) {
        return new ClassCastException(String.format("Expected '%s' on %s, got %s", this.getClassName(expectedType), location, this));
    }

    public <T> T as(Class<T> expectedType) {
        try {
            return expectedType.cast(this.value);
        }
        catch (ClassCastException e) {
            throw this.castException(expectedType);
        }
    }

    public <T> T as(Class<T> expectedType, String location) {
        try {
            return expectedType.cast(this.value);
        }
        catch (ClassCastException e) {
            throw this.castException(expectedType, location);
        }
    }

    public void checkType(Class<?> expectedType) {
        if (!expectedType.isInstance(this.value)) {
            throw this.castException(expectedType);
        }
    }

    public void checkType(Class<?> expectedType, String location) {
        if (!expectedType.isInstance(this.value)) {
            throw this.castException(expectedType, location);
        }
    }

    public boolean is(Class<?> type) {
        return this.type == type;
    }

    public MetaObject getMetaObject() {
        if (!this.metaObject.isPresent()) {
            MetaObject defaultMetaObject = this.domain.getDefaultMetaObject(this.type);
            this.metaObject = Optional.of((Object)defaultMetaObject);
        }
        return (MetaObject)this.metaObject.get();
    }

    public TypedValue updateMetaObject(MetaObject newMetaObject) {
        return new TypedValue(this.domain, this.type, this.value, newMetaObject);
    }
}

