/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.multi;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import info.openmods.calc.Frame;
import info.openmods.calc.executable.UnaryOperator;
import info.openmods.calc.types.multi.MetaObject;
import info.openmods.calc.types.multi.TypeDomain;
import info.openmods.calc.types.multi.TypedValue;
import info.openmods.calc.utils.Stack;
import info.openmods.calc.utils.reflection.TypeVariableHolder;
import info.openmods.calc.utils.reflection.TypeVariableHolderFiller;
import java.lang.reflect.TypeVariable;
import java.util.Map;

public class TypedUnaryOperator {

    private static class NonMeta
    extends UnaryOperator.Direct<TypedValue> {
        private final Logic logic;

        public NonMeta(String id, int precendence, Logic logic) {
            super(id, precendence);
            this.logic = logic;
        }

        @Override
        public TypedValue execute(TypedValue value) {
            return this.logic.execute(value);
        }
    }

    private static class Meta
    extends UnaryOperator.StackBased<TypedValue> {
        private final Logic logic;

        public Meta(String id, int precedence, Logic logic) {
            super(id, precedence);
            this.logic = logic;
        }

        @Override
        public void executeOnStack(Frame<TypedValue> frame) {
            Stack<TypedValue> stack = frame.stack();
            TypedValue value = stack.pop();
            MetaObject.SlotUnaryOp slotUnaryOp = value.getMetaObject().slotsUnaryOps.get(this.id);
            TypedValue result = slotUnaryOp != null ? slotUnaryOp.op(value, frame) : this.logic.execute(value);
            stack.push(result);
        }
    }

    private static class Logic {
        private final String id;
        private final Map<Class<?>, IGenericOperation> operations;
        private final IDefaultOperation defaultOperation;
        private final TypeDomain domain;

        public Logic(String id, Map<Class<?>, IGenericOperation> operations, IDefaultOperation defaultOperation, TypeDomain domain) {
            this.id = id;
            this.operations = ImmutableMap.copyOf(operations);
            this.defaultOperation = defaultOperation;
            this.domain = domain;
        }

        public TypedValue execute(TypedValue value) {
            Optional<TypedValue> result;
            Preconditions.checkState((value.domain == this.domain ? 1 : 0) != 0, (String)"Value belongs to different domain: %s", (Object[])new Object[]{value});
            IGenericOperation op = this.operations.get(value.type);
            if (op != null) {
                return op.apply(value.domain, value);
            }
            if (this.defaultOperation != null && (result = this.defaultOperation.apply(value.domain, value)).isPresent()) {
                return (TypedValue)result.get();
            }
            throw new IllegalArgumentException(String.format("Can't apply operation '%s' on value %s", this.id, value));
        }
    }

    public static class Builder {
        private final String id;
        private final int precendence;
        private final Map<Class<?>, IGenericOperation> operations = Maps.newHashMap();
        private IDefaultOperation defaultOperation;
        private boolean addMetaObjectOverride = true;

        public Builder(String id, int precedence) {
            this.id = id;
            this.precendence = precedence;
        }

        private static <T> Class<T> resolveVariable(TypeToken<?> token, TypeVariable<?> var) {
            return token.resolveType(var).getRawType();
        }

        private Builder registerOperation(Class<?> argCls, IGenericOperation op) {
            IGenericOperation prev = this.operations.put(argCls, op);
            Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Duplicate operation registration on operator '%s' for type %s", (Object[])new Object[]{this.id, argCls});
            return this;
        }

        public <A> Builder registerOperation(Class<? extends A> argCls, IOperation<? super A> op) {
            return this.registerOperation(argCls, Builder.createOperationWrapper(argCls, op));
        }

        private static <A> IGenericOperation createOperationWrapper(final Class<? extends A> argCls, final IOperation<? super A> op) {
            return new IGenericOperation(){

                @Override
                public TypedValue apply(TypeDomain domain, TypedValue argValue) {
                    Object arg = argValue.unwrap(argCls);
                    return op.apply(domain, arg);
                }

                @Override
                public void validate(TypeDomain domain) {
                    Preconditions.checkState((boolean)domain.isKnownType(argCls), (String)"Parameter type %s not in domain", (Object[])new Object[]{argCls});
                }
            };
        }

        public <A, R> Builder registerOperation(Class<? extends A> argCls, Class<? super R> resultCls, ISimpleOperation<? super A, ? extends R> op) {
            return this.registerOperation(argCls, Builder.createOperationWrapper(argCls, resultCls, op));
        }

        private static <A, R> IGenericOperation createOperationWrapper(final Class<? extends A> argCls, final Class<? super R> resultCls, final ISimpleOperation<? super A, ? extends R> op) {
            return new IGenericOperation(){

                @Override
                public TypedValue apply(TypeDomain domain, TypedValue argValue) {
                    Object value = argValue.unwrap(argCls);
                    Object result = op.apply(value);
                    return domain.create(resultCls, result);
                }

                @Override
                public void validate(TypeDomain domain) {
                    Preconditions.checkState((boolean)domain.isKnownType(argCls), (String)"Parameter type %s not in domain", (Object[])new Object[]{argCls});
                    Preconditions.checkState((boolean)domain.isKnownType(resultCls), (String)"Return type %s not in domain", (Object[])new Object[]{resultCls});
                }
            };
        }

        public <A> Builder registerOperation(IOperation<A> op) {
            TypeToken token = TypeToken.of(op.getClass());
            Class type = Builder.resolveVariable(token, TypeVariableHolders.Operation.A);
            return this.registerOperation(type, op);
        }

        public <A, R> Builder registerOperation(ISimpleOperation<A, R> op) {
            TypeToken token = TypeToken.of(op.getClass());
            Class argType = Builder.resolveVariable(token, TypeVariableHolders.SimpleOperation.A);
            Class resultType = Builder.resolveVariable(token, TypeVariableHolders.SimpleOperation.R);
            return this.registerOperation(argType, resultType, op);
        }

        public Builder setDefaultOperation(IDefaultOperation defaultOperation) {
            this.defaultOperation = defaultOperation;
            return this;
        }

        public Builder setNoMetaObjectOverride() {
            this.addMetaObjectOverride = false;
            return this;
        }

        public UnaryOperator<TypedValue> build(TypeDomain domain) {
            for (IGenericOperation op : this.operations.values()) {
                op.validate(domain);
            }
            Logic logic = new Logic(this.id, this.operations, this.defaultOperation, domain);
            return this.addMetaObjectOverride ? new Meta(this.id, this.precendence, logic) : new NonMeta(this.id, this.precendence, logic);
        }

        static {
            TypeVariableHolderFiller.instance.initialize(TypeVariableHolders.class);
        }

        private static class TypeVariableHolders {
            private TypeVariableHolders() {
            }

            @TypeVariableHolder(value=ISimpleOperation.class)
            public static class SimpleOperation {
                public static TypeVariable<?> A;
                public static TypeVariable<?> R;
            }

            @TypeVariableHolder(value=IOperation.class)
            public static class Operation {
                public static TypeVariable<?> A;
            }
        }
    }

    public static interface IDefaultOperation {
        public Optional<TypedValue> apply(TypeDomain var1, TypedValue var2);
    }

    private static interface IGenericOperation {
        public TypedValue apply(TypeDomain var1, TypedValue var2);

        public void validate(TypeDomain var1);
    }

    public static interface ISimpleOperation<A, R> {
        public R apply(A var1);
    }

    public static interface IOperation<A> {
        public TypedValue apply(TypeDomain var1, A var2);
    }
}

