/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.multi;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.reflect.TypeToken;
import info.openmods.calc.types.multi.IConverter;
import info.openmods.calc.types.multi.MetaObject;
import info.openmods.calc.types.multi.TypedValue;
import info.openmods.calc.utils.reflection.TypeVariableHolder;
import info.openmods.calc.utils.reflection.TypeVariableHolderFiller;
import java.lang.reflect.TypeVariable;
import java.util.Map;

public class TypeDomain {
    private final MetaObject defaultMetaObject;
    private final Map<Class<?>, TypeInfo> allowedTypes = Maps.newIdentityHashMap();
    private final Table<Class<?>, Class<?>, RawConverter> converters = HashBasedTable.create();
    private static final Map<Coercion, Coercion> inverses;
    private final Table<Class<?>, Class<?>, Coercion> coercionRules = HashBasedTable.create();

    public TypeDomain() {
        this.defaultMetaObject = MetaObject.builder().build();
    }

    public TypeDomain(MetaObject defaultMetaObject) {
        this.defaultMetaObject = defaultMetaObject;
    }

    public TypeDomain registerType(Class<?> type) {
        return this.registerType(type, type.getSimpleName());
    }

    public TypeDomain registerType(Class<?> type, String shortName) {
        return this.registerType(type, shortName, this.defaultMetaObject);
    }

    public TypeDomain registerType(Class<?> type, String shortName, MetaObject defaultMetaObject) {
        return this.registerType(type, shortName, defaultMetaObject, null);
    }

    public <T> TypeDomain registerType(Class<T> type, String shortName, MetaObject defaultMetaObject, T defaultValue) {
        if (defaultValue == null) {
            this.allowedTypes.put(type, new TypeInfo(shortName, defaultMetaObject, null));
        } else {
            TypedValue defaultWrappedValue = new TypedValue(this, type, defaultValue);
            this.allowedTypes.put(type, new TypeInfo(shortName, defaultMetaObject, defaultWrappedValue));
        }
        return this;
    }

    public boolean isKnownType(Class<?> type) {
        return this.allowedTypes.containsKey(type);
    }

    public void checkIsKnownType(Class<?> type) {
        Preconditions.checkState((boolean)this.allowedTypes.containsKey(type), (String)"Type '%s' is not allowed in domain", (Object[])new Object[]{type});
    }

    public String getName(Class<?> type) {
        TypeInfo typeInfo = this.allowedTypes.get(type);
        Preconditions.checkState((typeInfo != null ? 1 : 0) != 0, (String)"Type %s is not registered", (Object[])new Object[]{type});
        return typeInfo.name;
    }

    public Optional<String> tryGetName(Class<?> type) {
        TypeInfo typeInfo = this.allowedTypes.get(type);
        if (typeInfo == null) {
            return Optional.absent();
        }
        return Optional.of((Object)typeInfo.name);
    }

    public MetaObject getDefaultMetaObject(Class<?> type) {
        TypeInfo typeInfo = this.allowedTypes.get(type);
        Preconditions.checkState((typeInfo != null ? 1 : 0) != 0, (String)"Type %s is not registered", (Object[])new Object[]{type});
        return typeInfo.defaultMetaObject;
    }

    public <T> TypeDomain registerCast(Class<? extends T> source, Class<T> target) {
        this.checkIsKnownType(source);
        this.checkIsKnownType(target);
        RawConverter prev = (RawConverter)this.converters.put(source, target, new CastConverter<T>(target));
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Duplicate registration for types (%s,%s)", (Object[])new Object[]{source, target});
        return this;
    }

    public <S, T> TypeDomain registerConverter(Class<? extends S> source, Class<? extends T> target, IConverter<S, T> converter) {
        this.checkIsKnownType(source);
        this.checkIsKnownType(target);
        RawConverter prev = (RawConverter)this.converters.put(source, target, new WrappedConverter<S, T>(source, converter));
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Duplicate registration for types (%s,%s)", (Object[])new Object[]{source, target});
        return this;
    }

    public <S, T> TypeDomain registerConverter(IConverter<S, T> converter) {
        TypeToken converterType = TypeToken.of(converter.getClass());
        Class sourceType = converterType.resolveType(TypeVariableHolders.Converter.S).getRawType();
        Class targetType = converterType.resolveType(TypeVariableHolders.Converter.T).getRawType();
        return this.registerConverter(sourceType, targetType, converter);
    }

    private RawConverter getConverter(TypedValue value, Class<?> type) {
        RawConverter converter = (RawConverter)this.converters.get(value.type, type);
        Preconditions.checkArgument((converter != null ? 1 : 0) != 0, (String)"No known conversion from %s to %s", (Object[])new Object[]{value.type, type});
        return converter;
    }

    public boolean hasConversion(Class<?> from, Class<?> to) {
        return this.converters.contains(from, to);
    }

    public void checkConversion(Class<?> from, Class<?> to) {
        Preconditions.checkArgument((boolean)this.hasConversion(from, to), (String)"No known conversion from %s to %s", (Object[])new Object[]{from, to});
    }

    public TypedValue convert(TypedValue value, Class<?> type) {
        Preconditions.checkArgument((value.domain == this ? 1 : 0) != 0, (Object)"Mixed domain");
        if (value.type == type) {
            return value;
        }
        RawConverter converter = this.getConverter(value, type);
        Object convertedValue = converter.convert(value.value);
        return new TypedValue(this, type, convertedValue);
    }

    public <T> T unwrap(TypedValue value, Class<T> type) {
        Preconditions.checkArgument((value.domain == this ? 1 : 0) != 0, (Object)"Mixed domain");
        if (value.type == type) {
            return value.as(type);
        }
        RawConverter converter = this.getConverter(value, type);
        Object convertedValue = converter.convert(value.value);
        return type.cast(convertedValue);
    }

    public TypeDomain registerCoercionRule(Class<?> left, Class<?> right, Coercion rule) {
        this.checkIsKnownType(left);
        this.checkIsKnownType(right);
        Preconditions.checkArgument((left != right ? 1 : 0) != 0);
        if (rule == Coercion.TO_LEFT) {
            this.checkConversion(right, left);
        } else if (rule == Coercion.TO_RIGHT) {
            this.checkConversion(left, right);
        }
        Coercion prev = (Coercion)((Object)this.coercionRules.put(left, right, (Object)rule));
        Preconditions.checkState((prev == null || prev == rule ? 1 : 0) != 0, (String)"Duplicate coercion rule for (%s,%s): %s -> %s", (Object[])new Object[]{left, right, rule});
        return this;
    }

    public TypeDomain registerSymmetricCoercionRule(Class<?> left, Class<?> right, Coercion rule) {
        this.registerCoercionRule(left, right, rule);
        this.registerCoercionRule(right, left, inverses.get((Object)rule));
        return this;
    }

    public Coercion getCoercionRule(Class<?> left, Class<?> right) {
        if (left == right) {
            return Coercion.TO_LEFT;
        }
        Coercion result = (Coercion)((Object)this.coercionRules.get(left, right));
        return result != null ? result : Coercion.INVALID;
    }

    public <T> TypedValue getDefault(Class<T> type) {
        TypeInfo typeInfo = this.allowedTypes.get(type);
        Preconditions.checkState((typeInfo != null ? 1 : 0) != 0, (String)"Type '%s' is not allowed in domain", (Object[])new Object[]{type});
        Preconditions.checkState((typeInfo.defaultValue != null ? 1 : 0) != 0, (Object)"Type %s has no default value");
        return typeInfo.defaultValue;
    }

    public <T> TypedValue create(Class<T> type, T value) {
        this.checkIsKnownType(type);
        return new TypedValue(this, type, value);
    }

    public <T> TypedValue create(Class<T> type, T value, MetaObject metaObject) {
        this.checkIsKnownType(type);
        return new TypedValue(this, type, value, metaObject);
    }

    public <T> TypedValue castAndCreate(Class<T> type, Object value) {
        return this.create(type, type.cast(value));
    }

    public <T> Function<T, TypedValue> createWrappingTransformer(final Class<T> type) {
        this.checkIsKnownType(type);
        return new Function<T, TypedValue>(){

            public TypedValue apply(T input) {
                return TypeDomain.this.create(type, input);
            }
        };
    }

    public <T> Function<T, TypedValue> createWrappingTransformer(final Class<T> type, final TypedValue nullValue) {
        this.checkIsKnownType(type);
        Preconditions.checkArgument((nullValue.domain == this ? 1 : 0) != 0, (Object)"Different domains");
        return new Function<T, TypedValue>(){

            public TypedValue apply(T input) {
                return input != null ? TypeDomain.this.create(type, input) : nullValue;
            }
        };
    }

    public <T> Function<TypedValue, T> createUnwrappingTransformer(final Class<T> type) {
        this.checkIsKnownType(type);
        return new Function<TypedValue, T>(){

            public T apply(TypedValue input) {
                return input.as(type);
            }
        };
    }

    public <T> Function<TypedValue, T> createUnwrappingTransformer(final Class<T> type, final TypedValue nullValue) {
        this.checkIsKnownType(type);
        Preconditions.checkArgument((nullValue.domain == this ? 1 : 0) != 0, (Object)"Different domains");
        return new Function<TypedValue, T>(){

            public T apply(TypedValue input) {
                return !nullValue.equals(input) ? (Object)input.as(type) : null;
            }
        };
    }

    static {
        TypeVariableHolderFiller.instance.initialize(TypeVariableHolders.class);
        inverses = Maps.newEnumMap(Coercion.class);
        inverses.put(Coercion.TO_LEFT, Coercion.TO_RIGHT);
        inverses.put(Coercion.TO_RIGHT, Coercion.TO_LEFT);
        inverses.put(Coercion.INVALID, Coercion.INVALID);
    }

    public static enum Coercion {
        TO_LEFT,
        TO_RIGHT,
        INVALID;

    }

    private static class TypeInfo {
        public final String name;
        public final MetaObject defaultMetaObject;
        public final TypedValue defaultValue;

        public TypeInfo(String name, MetaObject defaultMetaObject, TypedValue defaultValue) {
            this.name = name;
            this.defaultMetaObject = defaultMetaObject;
            this.defaultValue = defaultValue;
        }
    }

    private static class CastConverter<T>
    implements RawConverter {
        private final Class<? extends T> target;

        public CastConverter(Class<? extends T> target) {
            this.target = target;
        }

        @Override
        public Object convert(Object value) {
            return this.target.cast(value);
        }
    }

    private static class WrappedConverter<S, T>
    implements RawConverter {
        private final Class<? extends S> source;
        private final IConverter<S, T> converter;

        public WrappedConverter(Class<? extends S> source, IConverter<S, T> converter) {
            this.source = source;
            this.converter = converter;
        }

        @Override
        public Object convert(Object value) {
            S input = this.source.cast(value);
            T result = this.converter.convert(input);
            return result;
        }
    }

    private static class TypeVariableHolders {
        private TypeVariableHolders() {
        }

        @TypeVariableHolder(value=IConverter.class)
        public static class Converter {
            public static TypeVariable<?> S;
            public static TypeVariable<?> T;
        }
    }

    private static interface RawConverter {
        public Object convert(Object var1);
    }
}

