/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.multi;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import info.openmods.calc.Frame;
import info.openmods.calc.IValuePrinter;
import info.openmods.calc.executable.IExecutable;
import info.openmods.calc.parsing.ast.IParserState;
import info.openmods.calc.parsing.ast.SingleStateTransition;
import info.openmods.calc.parsing.node.IExprNode;
import info.openmods.calc.parsing.postfix.SingleTokenPostfixParserState;
import info.openmods.calc.parsing.token.Token;
import info.openmods.calc.parsing.token.TokenType;
import info.openmods.calc.symbol.ISymbol;
import info.openmods.calc.symbol.SymbolMap;
import info.openmods.calc.types.multi.TypeDomain;
import info.openmods.calc.types.multi.TypedValue;
import java.util.ArrayList;
import java.util.List;

public class StringInterpolate {
    private static final ITemplatePart BRACKET_START_PART = new ITemplatePart(){

        @Override
        public void append(IValuePrinter<TypedValue> printer, SymbolMap<TypedValue> symbols, StringBuilder output) {
            output.append('{');
        }
    };
    private static final ITemplatePart BRACKET_END_PART = new ITemplatePart(){

        @Override
        public void append(IValuePrinter<TypedValue> printer, SymbolMap<TypedValue> symbols, StringBuilder output) {
            output.append('}');
        }
    };
    private static final TemplatePartInfo BRACKET_START_INFO = new TemplatePartInfo(TemplatePartType.BRACKET_START, "{");
    private static final TemplatePartInfo BRACKET_END_INFO = new TemplatePartInfo(TemplatePartType.BRACKET_END, "}");

    public static List<TemplatePartInfo> parseTemplate(String template) {
        ArrayList parts = Lists.newArrayList();
        int sectionStart = 0;
        ParsingState state = ParsingState.OUTSIDE_QUOTE;
        block6: for (int currentPos = 0; currentPos < template.length(); ++currentPos) {
            char ch = template.charAt(currentPos);
            switch (state) {
                case OUTSIDE_QUOTE: {
                    if (ch == '{') {
                        state = ParsingState.BRACKET_START;
                        if (sectionStart >= currentPos) continue block6;
                        parts.add(new TemplatePartInfo(TemplatePartType.CONST, template.substring(sectionStart, currentPos)));
                        continue block6;
                    }
                    if (ch != '}') continue block6;
                    state = ParsingState.BRACKET_END;
                    if (sectionStart >= currentPos) continue block6;
                    parts.add(new TemplatePartInfo(TemplatePartType.CONST, template.substring(sectionStart, currentPos)));
                    continue block6;
                }
                case BRACKET_START: {
                    if (ch == '{') {
                        state = ParsingState.OUTSIDE_QUOTE;
                        parts.add(BRACKET_START_INFO);
                        sectionStart = currentPos + 1;
                        continue block6;
                    }
                    if (ch == '}') {
                        throw new IllegalStateException("Unmatched bracket");
                    }
                    state = ParsingState.INSIDE_VAR_BRACKET;
                    sectionStart = currentPos;
                    continue block6;
                }
                case BRACKET_END: {
                    if (ch == '}') {
                        state = ParsingState.OUTSIDE_QUOTE;
                        parts.add(BRACKET_END_INFO);
                        sectionStart = currentPos + 1;
                        continue block6;
                    }
                    throw new IllegalStateException("Unmatched bracket");
                }
                case INSIDE_VAR_BRACKET: {
                    if (ch != '}') continue block6;
                    state = ParsingState.OUTSIDE_QUOTE;
                    parts.add(new TemplatePartInfo(TemplatePartType.VAR, template.substring(sectionStart, currentPos)));
                    sectionStart = currentPos + 1;
                    continue block6;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        Preconditions.checkState((state == ParsingState.OUTSIDE_QUOTE ? 1 : 0) != 0, (Object)"Invalid brackets");
        if (sectionStart < template.length()) {
            parts.add(new TemplatePartInfo(TemplatePartType.CONST, template.substring(sectionStart)));
        }
        return parts;
    }

    public static class StringInterpolatePostfixCompilerState
    extends SingleTokenPostfixParserState<IExecutable<TypedValue>> {
        private final TypeDomain domain;
        private final IValuePrinter<TypedValue> printer;

        public StringInterpolatePostfixCompilerState(TypeDomain domain, IValuePrinter<TypedValue> printer) {
            this.domain = domain;
            this.printer = printer;
        }

        @Override
        protected IExecutable<TypedValue> parseToken(Token token) {
            Preconditions.checkState((token.type == TokenType.STRING ? 1 : 0) != 0, (String)"Expected string token, got %s", (Object[])new Object[]{token});
            return new StringInterpolateExecutable(this.domain, this.printer, token.value);
        }
    }

    public static class StringInterpolateModifier
    extends SingleStateTransition.ForModifier<IExprNode<TypedValue>> {
        private final TypeDomain domain;
        private final IValuePrinter<TypedValue> printer;

        public StringInterpolateModifier(TypeDomain domain, IValuePrinter<TypedValue> printer) {
            this.domain = domain;
            this.printer = printer;
        }

        @Override
        public IExprNode<TypedValue> createRootNode(IExprNode<TypedValue> child) {
            return child;
        }

        @Override
        public IExprNode<TypedValue> parseSymbol(IParserState<IExprNode<TypedValue>> state, PeekingIterator<Token> input) {
            Token token = (Token)input.next();
            Preconditions.checkState((token.type == TokenType.STRING ? 1 : 0) != 0, (String)"Expected string token, got %s", (Object[])new Object[]{token});
            final String template = token.value;
            return new IExprNode<TypedValue>(){

                @Override
                public Iterable<IExprNode<TypedValue>> getChildren() {
                    return ImmutableList.of();
                }

                @Override
                public void flatten(List<IExecutable<TypedValue>> output) {
                    output.add(new StringInterpolateExecutable(StringInterpolateModifier.this.domain, StringInterpolateModifier.this.printer, template));
                }
            };
        }
    }

    private static class StringInterpolateExecutable
    implements IExecutable<TypedValue> {
        private final TypeDomain domain;
        private final IValuePrinter<TypedValue> printer;
        private final List<ITemplatePart> parts;

        public StringInterpolateExecutable(TypeDomain domain, IValuePrinter<TypedValue> printer, String template) {
            this.domain = domain;
            this.printer = printer;
            this.parts = ImmutableList.copyOf((Iterable)Iterables.transform(StringInterpolate.parseTemplate(template), (Function)new Function<TemplatePartInfo, ITemplatePart>(){

                public ITemplatePart apply(TemplatePartInfo input) {
                    return input.createPart();
                }
            }));
        }

        @Override
        public void execute(Frame<TypedValue> frame) {
            SymbolMap<TypedValue> symbols = frame.symbols();
            StringBuilder buffer = new StringBuilder();
            for (ITemplatePart part : this.parts) {
                part.append(this.printer, symbols, buffer);
            }
            frame.stack().push(this.domain.create(String.class, buffer.toString()));
        }
    }

    private static enum ParsingState {
        OUTSIDE_QUOTE,
        BRACKET_START,
        BRACKET_END,
        INSIDE_VAR_BRACKET;

    }

    public static class TemplatePartInfo {
        public final TemplatePartType type;
        public final String contents;

        public TemplatePartInfo(TemplatePartType type, String contents) {
            this.type = type;
            this.contents = contents;
        }

        public ITemplatePart createPart() {
            return this.type.createPart(this.contents);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.contents == null ? 0 : this.contents.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof TemplatePartInfo) {
                TemplatePartInfo other = (TemplatePartInfo)obj;
                return Objects.equal((Object)this.contents, (Object)other.contents) && this.type == other.type;
            }
            return false;
        }

        public String toString() {
            return (Object)((Object)this.type) + ":" + this.contents;
        }
    }

    public static enum TemplatePartType {
        CONST{

            @Override
            protected ITemplatePart createPart(final String contents) {
                return new ITemplatePart(){

                    @Override
                    public void append(IValuePrinter<TypedValue> printer, SymbolMap<TypedValue> symbols, StringBuilder output) {
                        output.append(contents);
                    }
                };
            }
        }
        ,
        VAR{

            @Override
            protected ITemplatePart createPart(final String contents) {
                return new ITemplatePart(){

                    @Override
                    public void append(IValuePrinter<TypedValue> printer, SymbolMap<TypedValue> symbols, StringBuilder output) {
                        ISymbol<TypedValue> value = symbols.get(contents);
                        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)("No symbol: " + contents));
                        output.append(printer.str((TypedValue)value.get()));
                    }
                };
            }
        }
        ,
        BRACKET_START{

            @Override
            protected ITemplatePart createPart(String contents) {
                Preconditions.checkArgument((boolean)contents.equals("{"), (String)"Expected {, got %s", (Object[])new Object[]{contents});
                return BRACKET_START_PART;
            }
        }
        ,
        BRACKET_END{

            @Override
            protected ITemplatePart createPart(String contents) {
                Preconditions.checkArgument((boolean)contents.equals("}"), (String)"Expected }, got %s", (Object[])new Object[]{contents});
                return BRACKET_END_PART;
            }
        };


        protected abstract ITemplatePart createPart(String var1);
    }

    private static interface ITemplatePart {
        public void append(IValuePrinter<TypedValue> var1, SymbolMap<TypedValue> var2, StringBuilder var3);
    }
}

