/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.multi;

import com.google.common.base.Preconditions;
import info.openmods.calc.Frame;
import info.openmods.calc.symbol.ISymbol;
import info.openmods.calc.types.multi.MetaObject;
import info.openmods.calc.types.multi.TypedValue;
import info.openmods.calc.utils.OptionalInt;

public class SlotCallableValueSymbol
implements ISymbol<TypedValue> {
    private final TypedValue value;
    private final MetaObject.SlotCall slot;

    public SlotCallableValueSymbol(TypedValue value) {
        this.value = value;
        this.slot = value.getMetaObject().slotCall;
        Preconditions.checkState((this.slot != null ? 1 : 0) != 0, (String)"Value %s it not callable", (Object[])new Object[]{value});
    }

    @Override
    public void call(Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
        this.slot.call(this.value, argumentsCount, returnsCount, frame);
    }

    @Override
    public TypedValue get() {
        return this.value;
    }
}

