/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.multi;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import info.openmods.calc.Environment;
import info.openmods.calc.Frame;
import info.openmods.calc.executable.IExecutable;
import info.openmods.calc.executable.SymbolCall;
import info.openmods.calc.executable.Value;
import info.openmods.calc.parsing.ast.IParserState;
import info.openmods.calc.parsing.ast.ISymbolCallStateTransition;
import info.openmods.calc.parsing.ast.SameStateSymbolTransition;
import info.openmods.calc.parsing.node.IExprNode;
import info.openmods.calc.parsing.node.SymbolCallNode;
import info.openmods.calc.symbol.FixedCallable;
import info.openmods.calc.types.multi.Code;
import info.openmods.calc.types.multi.MetaObjectUtils;
import info.openmods.calc.types.multi.TypeDomain;
import info.openmods.calc.types.multi.TypedValue;
import java.util.List;

public class IfExpressionFactory {
    private final TypeDomain domain;

    public IfExpressionFactory(TypeDomain domain) {
        this.domain = domain;
    }

    public ISymbolCallStateTransition<IExprNode<TypedValue>> createStateTransition(IParserState<IExprNode<TypedValue>> parentState) {
        return new IfStateTransition(parentState);
    }

    public void registerSymbol(Environment<TypedValue> env) {
        env.setGlobalSymbol("if", (TypedValue)((Object)new IfSymbol()));
    }

    private class IfSymbol
    extends FixedCallable<TypedValue> {
        public IfSymbol() {
            super(3, 1);
        }

        @Override
        public void call(Frame<TypedValue> frame) {
            TypedValue ifFalse = frame.stack().pop();
            ifFalse.checkType(Code.class, "third (false branch) 'if' parameter");
            TypedValue ifTrue = frame.stack().pop();
            ifTrue.checkType(Code.class, "second (true branch) 'if' parameter");
            TypedValue condition = frame.stack().pop();
            (MetaObjectUtils.boolValue(frame, condition) ? ifTrue : ifFalse).as(Code.class).execute(frame);
        }
    }

    private class IfStateTransition
    extends SameStateSymbolTransition<IExprNode<TypedValue>> {
        public IfStateTransition(IParserState<IExprNode<TypedValue>> parentState) {
            super(parentState);
        }

        @Override
        public IExprNode<TypedValue> createRootNode(List<IExprNode<TypedValue>> children) {
            return new IfNode(children);
        }
    }

    private class IfNode
    extends SymbolCallNode<TypedValue> {
        public IfNode(List<IExprNode<TypedValue>> args) {
            super("if", args);
        }

        @Override
        public void flatten(List<IExecutable<TypedValue>> output) {
            ImmutableList args = ImmutableList.copyOf(this.getChildren());
            Preconditions.checkState((args.size() == 3 ? 1 : 0) != 0, (String)"Expected 3 parameter for 'if', got %s", (Object[])new Object[]{args.size()});
            IExprNode condition = (IExprNode)args.get(0);
            IExprNode ifTrue = (IExprNode)args.get(1);
            IExprNode ifFalse = (IExprNode)args.get(2);
            condition.flatten(output);
            output.add(Value.create(Code.flattenAndWrap(IfExpressionFactory.this.domain, ifTrue)));
            output.add(Value.create(Code.flattenAndWrap(IfExpressionFactory.this.domain, ifFalse)));
            output.add(new SymbolCall("if", 3, 1));
        }
    }
}

