/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.multi;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import info.openmods.calc.Frame;
import info.openmods.calc.symbol.BinaryFunction;
import info.openmods.calc.symbol.FixedCallable;
import info.openmods.calc.symbol.ICallable;
import info.openmods.calc.symbol.SingleReturnCallable;
import info.openmods.calc.symbol.UnaryFunction;
import info.openmods.calc.types.multi.CallableValue;
import info.openmods.calc.types.multi.Cons;
import info.openmods.calc.types.multi.MetaObject;
import info.openmods.calc.types.multi.MetaObjectUtils;
import info.openmods.calc.types.multi.OptionalType;
import info.openmods.calc.types.multi.TypeDomain;
import info.openmods.calc.types.multi.TypeUserdata;
import info.openmods.calc.types.multi.TypedCalcUtils;
import info.openmods.calc.types.multi.TypedValue;
import info.openmods.calc.utils.OptionalInt;
import info.openmods.calc.utils.Stack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DictSymbol {
    private final TypedValue nullValue;
    private final TypeDomain domain;
    private final TypedValue selfValue;

    public DictSymbol(TypedValue nullValue) {
        this.nullValue = nullValue;
        this.domain = nullValue.domain;
        this.domain.registerType(Dict.class, "dict", this.createValueMetaObject());
        this.selfValue = this.domain.create(TypeUserdata.class, new TypeUserdata("dict", Dict.class), this.createTypeMetaObject());
    }

    private MetaObject createTypeMetaObject() {
        return TypeUserdata.defaultMetaObject(this.domain).set(new MetaObject.SlotCall(){

            @Override
            public void call(TypedValue self, OptionalInt argumentsCount, OptionalInt returnsCount, Frame<TypedValue> frame) {
                Preconditions.checkState((boolean)argumentsCount.isPresent(), (Object)"'dict' symbol requires arguments count");
                TypedCalcUtils.expectSingleReturn(returnsCount);
                Stack<TypedValue> stack = frame.stack().substack(argumentsCount.get());
                HashMap values = Maps.newHashMap();
                DictSymbol.extractKeyValuesPairs(stack, values);
                TypedValue result = DictSymbol.this.domain.create(Dict.class, new Dict(values));
                stack.clear();
                stack.push(result);
            }
        }).build();
    }

    private static void extractKeyValuesPairs(Iterable<TypedValue> args, Map<TypedValue, TypedValue> output) {
        for (TypedValue arg : args) {
            if (arg.is(Cons.class)) {
                Cons pair = arg.as(Cons.class);
                output.put(pair.car, pair.cdr);
                continue;
            }
            throw new IllegalArgumentException("Expected key(symbol):value pair, got " + arg);
        }
    }

    private MetaObject createValueMetaObject() {
        return MetaObject.builder().set(new MetaObject.SlotCall(){

            @Override
            public void call(TypedValue self, OptionalInt argumentsCount, OptionalInt returnsCount, Frame<TypedValue> frame) {
                TypedCalcUtils.expectSingleReturn(returnsCount);
                Preconditions.checkState((boolean)argumentsCount.isPresent(), (Object)"This method requires arguments count");
                Stack<TypedValue> stack = frame.stack().substack(argumentsCount.get());
                Dict dict = self.as(Dict.class);
                HashMap newValues = Maps.newHashMap((Map)dict.values);
                DictSymbol.extractKeyValuesPairs(stack, newValues);
                stack.clear();
                stack.push(DictSymbol.this.domain.create(Dict.class, new Dict(newValues)));
            }
        }).set(new MetaObject.SlotType(){

            @Override
            public TypedValue type(TypedValue self, Frame<TypedValue> frame) {
                return DictSymbol.this.selfValue;
            }
        }).set(new MetaObject.SlotStr(){

            @Override
            public String str(TypedValue self, Frame<TypedValue> frame) {
                Dict dict = self.as(Dict.class);
                ArrayList entries = Lists.newArrayList();
                for (Map.Entry e : dict.values.entrySet()) {
                    entries.add(MetaObjectUtils.callStrSlot(frame, (TypedValue)e.getKey()) + ":" + MetaObjectUtils.callStrSlot(frame, (TypedValue)e.getValue()));
                }
                return "{" + Joiner.on((String)",").join((Iterable)entries) + "}";
            }
        }).set(new MetaObject.SlotRepr(){

            @Override
            public String repr(TypedValue self, Frame<TypedValue> frame) {
                Dict dict = self.as(Dict.class);
                ArrayList entries = Lists.newArrayList();
                for (Map.Entry e : dict.values.entrySet()) {
                    entries.add(MetaObjectUtils.callReprSlot(frame, (TypedValue)e.getKey()) + ":" + MetaObjectUtils.callReprSlot(frame, (TypedValue)e.getValue()));
                }
                return "dict(" + Joiner.on((String)",").join((Iterable)entries) + ")";
            }
        }).set(new MetaObject.SlotLength(){

            @Override
            public int length(TypedValue self, Frame<TypedValue> frame) {
                return self.as(Dict.class).values.size();
            }
        }).set(new MetaObject.SlotBool(){

            @Override
            public boolean bool(TypedValue self, Frame<TypedValue> frame) {
                return !self.as(Dict.class).values.isEmpty();
            }
        }).set(new MetaObject.SlotSlice(){

            @Override
            public TypedValue slice(TypedValue self, TypedValue index, Frame<TypedValue> frame) {
                return (TypedValue)Objects.firstNonNull(self.as(Dict.class).values.get(index), (Object)DictSymbol.this.nullValue);
            }
        }).set(new MetaObject.SlotAttr(){

            @Override
            public Optional<TypedValue> attr(TypedValue self, String key, Frame<TypedValue> frame) {
                return self.as(Dict.class).attr(key);
            }
        }).set(new MetaObject.SlotDir(){

            @Override
            public Iterable<String> dir(TypedValue self, Frame<TypedValue> frame) {
                return self.as(Dict.class).dir();
            }
        }).set(MetaObjectUtils.USE_VALUE_EQUALS).build();
    }

    public TypedValue value() {
        return this.selfValue;
    }

    private class Dict {
        private final Map<TypedValue, TypedValue> values;
        private final Map<String, TypedValue> members = Maps.newHashMap();
        private final Map<String, DelayedValue> delayedMembers = Maps.newHashMap();

        public Dict(Map<TypedValue, TypedValue> values) {
            this.values = ImmutableMap.copyOf(values);
            this.members.put("update", CallableValue.wrap(DictSymbol.this.domain, new UpdateMethod()));
            this.members.put("remove", CallableValue.wrap(DictSymbol.this.domain, new RemoveMethod()));
            this.members.put("hasKey", CallableValue.wrap(DictSymbol.this.domain, (ICallable<TypedValue>)new UnaryFunction.Direct<TypedValue>(){

                @Override
                protected TypedValue call(TypedValue key) {
                    return DictSymbol.this.domain.create(Boolean.class, Dict.this.values.containsKey(key));
                }
            }));
            this.members.put("getOptional", CallableValue.wrap(DictSymbol.this.domain, (ICallable<TypedValue>)new UnaryFunction.Direct<TypedValue>(){

                @Override
                protected TypedValue call(TypedValue key) {
                    return OptionalType.wrapNullable(DictSymbol.this.domain, (TypedValue)Dict.this.values.get(key));
                }
            }));
            this.members.put("getOr", CallableValue.wrap(DictSymbol.this.domain, (ICallable<TypedValue>)new BinaryFunction.Direct<TypedValue>(){

                @Override
                protected TypedValue call(TypedValue key, TypedValue defaultValue) {
                    TypedValue result = (TypedValue)Dict.this.values.get(key);
                    return result != null ? result : defaultValue;
                }
            }));
            this.members.put("getOrCall", CallableValue.wrap(DictSymbol.this.domain, (ICallable<TypedValue>)new FixedCallable<TypedValue>(2, 1){

                @Override
                public void call(Frame<TypedValue> frame) {
                    Stack<TypedValue> stack = frame.stack();
                    TypedValue defaultFunction = stack.pop();
                    TypedValue key = stack.pop();
                    TypedValue result = (TypedValue)Dict.this.values.get(key);
                    if (result != null) {
                        stack.push(result);
                    } else {
                        MetaObjectUtils.call(frame, defaultFunction, OptionalInt.ZERO, OptionalInt.ONE);
                    }
                }
            }));
            this.members.put("hasValue", CallableValue.wrap(DictSymbol.this.domain, (ICallable<TypedValue>)new UnaryFunction.Direct<TypedValue>(){

                @Override
                protected TypedValue call(TypedValue value) {
                    return DictSymbol.this.domain.create(Boolean.class, Dict.this.values.containsValue(value));
                }
            }));
            this.delayedMembers.put("keys", new EntriesAccessor(){

                @Override
                protected TypedValue getEntry(Map.Entry<TypedValue, TypedValue> e) {
                    return e.getKey();
                }
            });
            this.delayedMembers.put("values", new EntriesAccessor(){

                @Override
                protected TypedValue getEntry(Map.Entry<TypedValue, TypedValue> e) {
                    return e.getValue();
                }
            });
            this.delayedMembers.put("items", new EntriesAccessor(){

                @Override
                protected TypedValue getEntry(Map.Entry<TypedValue, TypedValue> e) {
                    return DictSymbol.this.domain.create(Cons.class, new Cons(e.getKey(), e.getValue()));
                }
            });
        }

        public Optional<TypedValue> attr(String key) {
            DelayedValue delayedValue;
            TypedValue member = this.members.get(key);
            if (member == null && !this.delayedMembers.isEmpty() && (delayedValue = this.delayedMembers.remove(key)) != null) {
                member = delayedValue.get();
                this.members.put(key, member);
            }
            return Optional.fromNullable((Object)member);
        }

        public Iterable<String> dir() {
            return Sets.union(this.members.keySet(), this.delayedMembers.keySet());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Dict) {
                Dict other = (Dict)o;
                return other.values.equals(this.values);
            }
            return false;
        }

        private abstract class EntriesAccessor
        implements DelayedValue {
            private EntriesAccessor() {
            }

            @Override
            public TypedValue get() {
                TypedValue result = DictSymbol.this.nullValue;
                for (Map.Entry<TypedValue, TypedValue> entry : Dict.this.values.entrySet()) {
                    TypedValue element = this.getEntry(entry);
                    result = DictSymbol.this.domain.create(Cons.class, new Cons(element, result));
                }
                return result;
            }

            protected abstract TypedValue getEntry(Map.Entry<TypedValue, TypedValue> var1);
        }

        private class RemoveMethod
        extends SingleReturnCallable<TypedValue> {
            private RemoveMethod() {
            }

            @Override
            public TypedValue call(Frame<TypedValue> frame, OptionalInt argumentsCount) {
                Preconditions.checkState((boolean)argumentsCount.isPresent(), (Object)"This method requires arguments count");
                Stack<TypedValue> args = frame.stack().substack(argumentsCount.get());
                HashMap newValues = Maps.newHashMap((Map)Dict.this.values);
                for (TypedValue arg : args) {
                    newValues.remove(arg);
                }
                TypedValue result = DictSymbol.this.domain.create(Dict.class, new Dict(newValues));
                args.clear();
                return result;
            }
        }

        private class UpdateMethod
        extends SingleReturnCallable<TypedValue> {
            private UpdateMethod() {
            }

            @Override
            public TypedValue call(Frame<TypedValue> frame, OptionalInt argumentsCount) {
                Preconditions.checkState((boolean)argumentsCount.isPresent(), (Object)"This method requires arguments count");
                Stack<TypedValue> args = frame.stack().substack(argumentsCount.get());
                HashMap newValues = Maps.newHashMap((Map)Dict.this.values);
                DictSymbol.extractKeyValuesPairs(args, newValues);
                TypedValue result = DictSymbol.this.domain.create(Dict.class, new Dict(newValues));
                args.clear();
                return result;
            }
        }
    }

    private static interface DelayedValue {
        public TypedValue get();
    }
}

