/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.multi;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import info.openmods.calc.types.multi.TypeDomain;
import info.openmods.calc.types.multi.TypedValue;
import java.util.Iterator;
import java.util.List;

public class Cons {
    public final TypedValue car;
    public final TypedValue cdr;

    public Cons(TypedValue car, TypedValue cdr) {
        Preconditions.checkNotNull((Object)car);
        Preconditions.checkNotNull((Object)cdr);
        Preconditions.checkArgument((car.domain == cdr.domain ? 1 : 0) != 0, (String)"Mismatched domain on %s %s", (Object[])new Object[]{car, cdr});
        this.car = car;
        this.cdr = cdr;
    }

    public static TypedValue create(TypeDomain domain, TypedValue car, TypedValue cdr) {
        return domain.create(Cons.class, new Cons(car, cdr));
    }

    public TypedValue first() {
        return this.car;
    }

    public TypedValue second() {
        return this.cdr;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.car == null ? 0 : this.car.hashCode());
        result = 31 * result + (this.cdr == null ? 0 : this.cdr.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Cons) {
            Cons other = (Cons)obj;
            return this.car.equals(other.car) && this.cdr.equals(other.cdr);
        }
        return false;
    }

    public String toString() {
        return "(" + this.car + " . " + this.cdr + ")";
    }

    public static TypedValue createList(List<TypedValue> elements, TypedValue terminatorValue) {
        int lastElement = elements.size() - 1;
        TypeDomain domain = terminatorValue.domain;
        TypedValue result = terminatorValue;
        for (int i = lastElement; i >= 0; --i) {
            result = domain.create(Cons.class, new Cons(elements.get(i), result));
        }
        return result;
    }

    public void visit(BranchingVisitor visitor) {
        visitor.begin();
        Cons e = this;
        while (true) {
            boolean hasNext = e.cdr.is(Cons.class);
            if (e.car.is(Cons.class)) {
                BranchingVisitor nestedVisitor = visitor.nestedValue(this.car);
                e.car.as(Cons.class).visit(nestedVisitor);
            } else {
                visitor.value(e.car, !hasNext);
            }
            if (!hasNext) break;
            e = e.cdr.as(Cons.class);
        }
        visitor.end(e.cdr);
    }

    public void visit(LinearVisitor visitor) {
        visitor.begin();
        Cons e = this;
        while (true) {
            boolean hasNext = e.cdr.is(Cons.class);
            visitor.value(e.car, !hasNext);
            if (!hasNext) break;
            e = e.cdr.as(Cons.class);
        }
        visitor.end(e.cdr);
    }

    public String prettyPrint() {
        final StringBuilder result = new StringBuilder();
        this.visit(new BranchingVisitor(){

            @Override
            public void begin() {
                result.append("(");
            }

            @Override
            public void value(TypedValue value, boolean isLast) {
                result.append(value);
                if (!isLast) {
                    result.append(" ");
                }
            }

            @Override
            public BranchingVisitor nestedValue(TypedValue value) {
                result.append("(");
                return this;
            }

            @Override
            public void end(TypedValue terminator) {
                result.append(" . ");
                result.append(terminator);
                result.append(")");
            }
        });
        return result.toString();
    }

    public int length() {
        int result = 1;
        TypedValue c = this.cdr;
        while (c.is(Cons.class)) {
            c = c.as(Cons.class).cdr;
            ++result;
        }
        return result;
    }

    public static Iterable<TypedValue> toIterable(final TypedValue value, final TypedValue nullValue) {
        return new Iterable<TypedValue>(){

            @Override
            public Iterator<TypedValue> iterator() {
                return new AbstractIterator<TypedValue>(){
                    private TypedValue c;
                    {
                        this.c = value;
                    }

                    protected TypedValue computeNext() {
                        if (this.c == nullValue) {
                            return (TypedValue)this.endOfData();
                        }
                        if (this.c.is(Cons.class)) {
                            Cons next = this.c.as(Cons.class);
                            this.c = next.cdr;
                            return next.car;
                        }
                        throw new IllegalArgumentException("Not a list: " + this.c);
                    }
                };
            }
        };
    }

    public static abstract class TypedRecursiveVisitor<T> {
        private final TypedValue nullValue;

        public TypedRecursiveVisitor(TypedValue nullValue) {
            this.nullValue = nullValue;
        }

        protected abstract T processValue(TypedValue var1, TypedValue var2);

        protected abstract T processEnd();

        public T process(TypedValue list) {
            if (list == this.nullValue) {
                return this.processEnd();
            }
            Cons cons = list.as(Cons.class);
            return this.processValue(cons.car, cons.cdr);
        }
    }

    public static abstract class RecursiveVisitor {
        private final TypedValue nullValue;

        public RecursiveVisitor(TypedValue nullValue) {
            this.nullValue = nullValue;
        }

        protected abstract TypedValue processValue(TypedValue var1, TypedValue var2);

        protected TypedValue processEnd() {
            return this.nullValue;
        }

        public TypedValue process(TypedValue list) {
            if (list == this.nullValue) {
                return this.processEnd();
            }
            Cons cons = list.as(Cons.class);
            return this.processValue(cons.car, cons.cdr);
        }
    }

    public static abstract class ListVisitor
    implements LinearVisitor {
        private final TypedValue expectedTerminator;

        public ListVisitor(TypedValue expectedTerminator) {
            this.expectedTerminator = expectedTerminator;
        }

        @Override
        public void begin() {
        }

        @Override
        public void end(TypedValue actualTerminator) {
            Preconditions.checkState((boolean)actualTerminator.equals(this.expectedTerminator), (String)"Not valid list: expected %s, got %s", (Object[])new Object[]{this.expectedTerminator, actualTerminator});
        }
    }

    public static interface LinearVisitor {
        public void begin();

        public void value(TypedValue var1, boolean var2);

        public void end(TypedValue var1);
    }

    public static interface BranchingVisitor {
        public void begin();

        public void value(TypedValue var1, boolean var2);

        public BranchingVisitor nestedValue(TypedValue var1);

        public void end(TypedValue var1);
    }
}

