/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.multi;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import info.openmods.calc.Frame;
import info.openmods.calc.FrameFactory;
import info.openmods.calc.symbol.ICallable;
import info.openmods.calc.symbol.SymbolMap;
import info.openmods.calc.types.multi.Code;
import info.openmods.calc.types.multi.Cons;
import info.openmods.calc.types.multi.IBindPattern;
import info.openmods.calc.types.multi.TypeDomain;
import info.openmods.calc.types.multi.TypedCalcUtils;
import info.openmods.calc.types.multi.TypedValue;
import info.openmods.calc.utils.OptionalInt;
import info.openmods.calc.utils.Stack;
import java.util.Iterator;
import java.util.List;

public class ClosureVar
implements ICallable<TypedValue> {
    private final TypedValue nullValue;
    private final SymbolMap<TypedValue> scopeSymbols;
    private final Code code;
    private final List<IBindPattern> args;
    private final String varArgName;

    public ClosureVar(TypedValue nullValue, SymbolMap<TypedValue> scopeSymbols, Code code, List<IBindPattern> args, String varArg) {
        this.nullValue = nullValue;
        this.code = code;
        this.scopeSymbols = scopeSymbols;
        this.args = ImmutableList.copyOf(args);
        this.varArgName = varArg;
    }

    @Override
    public void call(Frame<TypedValue> callsite, OptionalInt argumentsCount, OptionalInt returnsCount) {
        int allArgs;
        int mandatoryArgs = this.args.size();
        if (argumentsCount.isPresent()) {
            allArgs = argumentsCount.get();
            Preconditions.checkState((allArgs >= mandatoryArgs ? 1 : 0) != 0, (String)"Invalid numer or arguments, expected more than %s, got %s", (Object[])new Object[]{allArgs, mandatoryArgs});
        } else {
            allArgs = mandatoryArgs;
        }
        int extraArgs = allArgs - mandatoryArgs;
        Frame<TypedValue> executionFrame = FrameFactory.newClosureFrame(this.scopeSymbols, callsite, allArgs);
        Stack<TypedValue> executionStack = executionFrame.stack();
        SymbolMap<TypedValue> executionSymbols = executionFrame.symbols();
        TypeDomain domain = this.nullValue.domain;
        TypedValue varArgValue = this.nullValue;
        for (int i = 0; i < extraArgs; ++i) {
            TypedValue arg = executionStack.pop();
            varArgValue = Cons.create(domain, arg, varArgValue);
        }
        Iterator<TypedValue> argValues = executionStack.iterator();
        for (IBindPattern argPattern : this.args) {
            TypedValue argValue = argValues.next();
            TypedCalcUtils.matchPattern(argPattern, executionFrame, executionSymbols, argValue);
        }
        executionStack.clear();
        executionSymbols.put(this.varArgName, varArgValue);
        this.code.execute(executionFrame);
        TypedCalcUtils.expectExactReturnCount(returnsCount, executionStack.size());
    }
}

