/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.multi;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import info.openmods.calc.Frame;
import info.openmods.calc.FrameFactory;
import info.openmods.calc.symbol.ISymbol;
import info.openmods.calc.symbol.NestedSymbolMap;
import info.openmods.calc.symbol.SingleReturnCallable;
import info.openmods.calc.symbol.SymbolMap;
import info.openmods.calc.types.multi.BindPatternTranslator;
import info.openmods.calc.types.multi.Code;
import info.openmods.calc.types.multi.IBindPattern;
import info.openmods.calc.types.multi.MetaObject;
import info.openmods.calc.types.multi.TypeDomain;
import info.openmods.calc.types.multi.TypedCalcUtils;
import info.openmods.calc.types.multi.TypedValue;
import info.openmods.calc.utils.OptionalInt;
import info.openmods.calc.utils.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BindPatternEvaluator {
    private final TypeDomain domain;
    private final MetaObject namespaceCtorPlaceholderMetaObject = MetaObject.builder().set(new MetaObject.SlotAttr(){

        @Override
        public Optional<TypedValue> attr(TypedValue self, String key, Frame<TypedValue> frame) {
            NamespaceCtorPlaceholder placeholder = (NamespaceCtorPlaceholder)self.as(BindPatternTranslator.IBindPatternProvider.class);
            return Optional.of((Object)BindPatternEvaluator.this.domain.create(BindPatternTranslator.IBindPatternProvider.class, placeholder.extend(key), self.getMetaObject()));
        }
    }).set(new MetaObject.SlotCall(){

        @Override
        public void call(TypedValue self, OptionalInt argumentsCount, OptionalInt returnsCount, Frame<TypedValue> frame) {
            Preconditions.checkArgument((boolean)argumentsCount.isPresent(), (Object)"Type constructor must be always called with arg count");
            TypedCalcUtils.expectSingleReturn(returnsCount);
            NamespaceCtorPlaceholder placeholder = (NamespaceCtorPlaceholder)self.as(BindPatternTranslator.IBindPatternProvider.class);
            Stack<TypedValue> stack = frame.stack().substack(argumentsCount.get());
            BindPatternTranslator.IBindPatternProvider terminalPlaceholder = placeholder.terminate(stack);
            stack.clear();
            stack.push(BindPatternEvaluator.this.domain.create(BindPatternTranslator.IBindPatternProvider.class, terminalPlaceholder));
        }
    }).build();
    private final MetaObject varPlaceholderMetaObject = MetaObject.builder().set(new MetaObject.SlotAttr(){

        @Override
        public Optional<TypedValue> attr(TypedValue self, String key, Frame<TypedValue> frame) {
            VarPlaceholder placeholder = (VarPlaceholder)self.as(BindPatternTranslator.IBindPatternProvider.class);
            return Optional.of((Object)BindPatternEvaluator.this.domain.create(BindPatternTranslator.IBindPatternProvider.class, new NamespaceCtorPlaceholder(placeholder.var, (List<String>)ImmutableList.of((Object)key)), BindPatternEvaluator.this.namespaceCtorPlaceholderMetaObject));
        }
    }).set(new MetaObject.SlotCall(){

        @Override
        public void call(TypedValue self, OptionalInt argumentsCount, OptionalInt returnsCount, Frame<TypedValue> frame) {
            VarPlaceholder placeholder = (VarPlaceholder)self.as(BindPatternTranslator.IBindPatternProvider.class);
            TypedCalcUtils.expectSingleReturn(returnsCount);
            frame.stack().push(BindPatternEvaluator.this.createCtorPlaceholder(placeholder.var, frame, argumentsCount));
        }
    }).build();

    public BindPatternEvaluator(TypeDomain domain) {
        this.domain = domain;
    }

    private static List<IBindPattern> translatePatterns(BindPatternTranslator translator, List<TypedValue> args) {
        ArrayList varMatchers = Lists.newArrayList();
        for (TypedValue m : args) {
            varMatchers.add(translator.translatePattern(m));
        }
        return varMatchers;
    }

    private TypedValue createCtorPlaceholder(String name, Frame<TypedValue> frame, OptionalInt argumentsCount) {
        Preconditions.checkArgument((boolean)argumentsCount.isPresent(), (Object)"Type constructor must be always called with arg count");
        Stack<TypedValue> stack = frame.stack().substack(argumentsCount.get());
        CtorPlaceholder placeholder = new CtorPlaceholder(name, stack);
        stack.clear();
        return this.domain.create(BindPatternTranslator.IBindPatternProvider.class, placeholder);
    }

    public TypedValue evaluate(SymbolMap<TypedValue> topSymbolMap, Code pattern) {
        Frame<TypedValue> patternFrame = FrameFactory.symbolsToFrame(new PatternPlaceholdersSymbolMap(topSymbolMap));
        pattern.execute(patternFrame);
        return patternFrame.stack().popAndExpectEmptyStack();
    }

    private class PatternPlaceholdersSymbolMap
    extends NestedSymbolMap<TypedValue> {
        public PatternPlaceholdersSymbolMap(SymbolMap<TypedValue> parent) {
            super(parent);
        }

        @Override
        public void put(String name, ISymbol<TypedValue> symbol) {
            throw new UnsupportedOperationException("Can't create new symbols in match patterns");
        }

        @Override
        public ISymbol<TypedValue> get(String name) {
            ISymbol<TypedValue> parentSymbol = super.get(name);
            if (parentSymbol != null) {
                return parentSymbol;
            }
            return new PlaceholderSymbol(name);
        }
    }

    private class PlaceholderSymbol
    extends SingleReturnCallable<TypedValue>
    implements ISymbol<TypedValue> {
        private final String var;

        public PlaceholderSymbol(String var) {
            this.var = var;
        }

        @Override
        public TypedValue get() {
            return BindPatternEvaluator.this.domain.create(BindPatternTranslator.IBindPatternProvider.class, new VarPlaceholder(this.var), BindPatternEvaluator.this.varPlaceholderMetaObject);
        }

        @Override
        public TypedValue call(Frame<TypedValue> frame, OptionalInt argumentsCount) {
            return BindPatternEvaluator.this.createCtorPlaceholder(this.var, frame, argumentsCount);
        }
    }

    private static class NamespaceCtorPlaceholder
    implements BindPatternTranslator.IBindPatternProvider {
        private final String var;
        private final List<String> path;

        public NamespaceCtorPlaceholder(String var, List<String> path) {
            this.var = var;
            this.path = path;
        }

        @Override
        public IBindPattern getPattern(BindPatternTranslator translator) {
            throw new IllegalStateException("Unfinished namespace constructor matcher: " + this.var + "." + Joiner.on((String)".").join(this.path));
        }

        public BindPatternTranslator.IBindPatternProvider extend(String key) {
            ArrayList newPath = Lists.newArrayList(this.path);
            newPath.add(key);
            return new NamespaceCtorPlaceholder(this.var, newPath);
        }

        public BindPatternTranslator.IBindPatternProvider terminate(Iterable<TypedValue> args) {
            return new TerminalNamespaceCtorPlaceholder(this.var, this.path, args);
        }
    }

    private static class TerminalNamespaceCtorPlaceholder
    implements BindPatternTranslator.IBindPatternProvider {
        private final String var;
        private final List<String> path;
        private final List<TypedValue> args;

        public TerminalNamespaceCtorPlaceholder(String var, List<String> path, Iterable<TypedValue> args) {
            this.var = var;
            this.path = path;
            this.args = ImmutableList.copyOf(args);
        }

        @Override
        public IBindPattern getPattern(BindPatternTranslator translator) {
            return new PatternMatchNamespaceConstructor(BindPatternEvaluator.translatePatterns(translator, this.args), this.var, this.path);
        }
    }

    private static class PatternMatchNamespaceConstructor
    extends PatternMatchConstructor {
        private final String pathStart;
        private final List<String> path;

        public PatternMatchNamespaceConstructor(List<IBindPattern> argMatchers, String pathStart, List<String> path) {
            super(argMatchers);
            this.pathStart = pathStart;
            this.path = path;
        }

        @Override
        protected TypedValue findConstructor(Frame<TypedValue> env) {
            ISymbol<TypedValue> initialSymbol = env.symbols().get(this.pathStart);
            Preconditions.checkState((initialSymbol != null ? 1 : 0) != 0, (String)"Can't find symbol %s", (Object[])new Object[]{this.pathStart});
            TypedValue result = (TypedValue)initialSymbol.get();
            for (String p : this.path) {
                MetaObject.SlotAttr slotAttr = result.getMetaObject().slotAttr;
                Preconditions.checkState((slotAttr != null ? 1 : 0) != 0, (String)"Value %s is not structure", (Object[])new Object[]{result});
                Optional<TypedValue> maybeNewResult = slotAttr.attr(result, p, env);
                Preconditions.checkState((boolean)maybeNewResult.isPresent(), (String)"Can't find value %s in in %s", (Object[])new Object[]{p, result});
                result = (TypedValue)maybeNewResult.get();
            }
            return result;
        }

        @Override
        public String serialize() {
            return this.pathStart + "." + Joiner.on((String)".").join(this.path) + this.serializeArgNames();
        }
    }

    private static class CtorPlaceholder
    implements BindPatternTranslator.IBindPatternProvider {
        private final String var;
        private final List<TypedValue> args;

        public CtorPlaceholder(String var, Iterable<TypedValue> args) {
            this.var = var;
            this.args = ImmutableList.copyOf(args);
        }

        @Override
        public IBindPattern getPattern(BindPatternTranslator translator) {
            return new PatternMatchLocalConstructor(BindPatternEvaluator.translatePatterns(translator, this.args), this.var);
        }
    }

    private static class PatternMatchLocalConstructor
    extends PatternMatchConstructor {
        private final String typeName;

        public PatternMatchLocalConstructor(List<IBindPattern> argMatchers, String typeName) {
            super(argMatchers);
            this.typeName = typeName;
        }

        @Override
        protected TypedValue findConstructor(Frame<TypedValue> env) {
            ISymbol<TypedValue> type = env.symbols().get(this.typeName);
            Preconditions.checkState((type != null ? 1 : 0) != 0, (String)"Can't find decomposable constructor %s", (Object[])new Object[]{this.typeName});
            return (TypedValue)type.get();
        }

        @Override
        public String serialize() {
            return this.typeName + this.serializeArgNames();
        }
    }

    private static abstract class PatternMatchConstructor
    implements IBindPattern {
        private final List<IBindPattern> argMatchers;

        public PatternMatchConstructor(List<IBindPattern> argMatchers) {
            this.argMatchers = argMatchers;
        }

        @Override
        public boolean match(Frame<TypedValue> env, SymbolMap<TypedValue> output, TypedValue value) {
            TypedValue typeValue = this.findConstructor(env);
            MetaObject.SlotDecompose decomposer = typeValue.getMetaObject().slotDecompose;
            if (decomposer != null) {
                int expectedValueCount = this.argMatchers.size();
                Optional<List<TypedValue>> maybeDecomposition = decomposer.tryDecompose(typeValue, value, expectedValueCount, env);
                if (!maybeDecomposition.isPresent()) {
                    return false;
                }
                List decomposition = (List)maybeDecomposition.get();
                int actualValueCount = decomposition.size();
                Preconditions.checkState((actualValueCount == expectedValueCount ? 1 : 0) != 0, (String)"Decomposable contract broken - returned different number of values: expected: %s, got %s", (Object[])new Object[]{expectedValueCount, actualValueCount});
                for (int i = 0; i < actualValueCount; ++i) {
                    TypedValue var;
                    IBindPattern pattern = this.argMatchers.get(i);
                    if (pattern.match(env, output, var = (TypedValue)decomposition.get(i))) continue;
                    return false;
                }
                return true;
            }
            throw new IllegalStateException("Value " + typeValue + " does not describe constructor or type");
        }

        @Override
        public void listBoundVars(Collection<String> output) {
            for (IBindPattern pattern : this.argMatchers) {
                pattern.listBoundVars(output);
            }
        }

        protected abstract TypedValue findConstructor(Frame<TypedValue> var1);

        protected String serializeArgNames() {
            ArrayList args = Lists.newArrayList();
            for (IBindPattern arg : this.argMatchers) {
                args.add(arg.serialize());
            }
            return "(" + Joiner.on((String)",").join((Iterable)args) + ")";
        }
    }

    private static class VarPlaceholder
    implements BindPatternTranslator.IBindPatternProvider {
        public final String var;

        public VarPlaceholder(String var) {
            this.var = var;
        }

        @Override
        public IBindPattern getPattern(BindPatternTranslator translator) {
            return BindPatternTranslator.createPatternForVarName(this.var);
        }
    }
}

