/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.parsing.token;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;

public class TokenUtils {
    private static final BiMap<String, String> BRACKETS = ImmutableBiMap.of((Object)"(", (Object)")", (Object)"{", (Object)"}", (Object)"[", (Object)"]");

    public static boolean isOpeningBracket(String bracket) {
        return BRACKETS.containsKey((Object)bracket);
    }

    public static boolean isClosingBracket(String bracket) {
        return BRACKETS.containsValue((Object)bracket);
    }

    public static String getClosingBracket(String bracket) {
        return (String)BRACKETS.get((Object)bracket);
    }

    public static void checkIsValidBracketPair(String openingBracket, String closingBracket) {
        String expectedClosingBracket = TokenUtils.getClosingBracket(openingBracket);
        Preconditions.checkState((expectedClosingBracket != null ? 1 : 0) != 0, (String)"Unknown bracket: %s", (Object[])new Object[]{openingBracket});
        Preconditions.checkState((boolean)expectedClosingBracket.equals(closingBracket), (String)"Unmatched brackets: %s and %s, expected %s", (Object[])new Object[]{openingBracket, closingBracket, expectedClosingBracket});
    }
}

