/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.parsing.postfix;

import com.google.common.base.Preconditions;
import info.openmods.calc.executable.SymbolCall;
import info.openmods.calc.parsing.postfix.IExecutableListBuilder;
import info.openmods.calc.parsing.postfix.IPostfixParserState;
import info.openmods.calc.parsing.token.Token;
import info.openmods.calc.parsing.token.TokenType;
import info.openmods.calc.utils.OptionalInt;

public class SimplePostfixParserState<E>
implements IPostfixParserState<E> {
    final IExecutableListBuilder<E> builder;

    public SimplePostfixParserState(IExecutableListBuilder<E> builder) {
        this.builder = builder;
    }

    @Override
    public IPostfixParserState.Result acceptToken(Token token) {
        if (token.type == TokenType.OPERATOR) {
            this.builder.appendOperator(token.value);
        } else if (token.type == TokenType.SYMBOL) {
            this.builder.appendSymbolCall(token.value, SymbolCall.DEFAULT_ARG_COUNT, SymbolCall.DEFAULT_RET_COUNT);
        } else if (token.type == TokenType.SYMBOL_WITH_ARGS) {
            SimplePostfixParserState.parseSymbolWithArgs(token.value, this.builder);
        } else if (token.type.isValue()) {
            this.builder.appendValue(token);
        } else {
            return IPostfixParserState.Result.REJECTED;
        }
        return IPostfixParserState.Result.ACCEPTED;
    }

    private static <E> void parseSymbolWithArgs(String value, IExecutableListBuilder<E> output) {
        int argsStart = value.lastIndexOf(36);
        Preconditions.checkArgument((argsStart >= 0 ? 1 : 0) != 0, (String)"No args in token '%s'", (Object[])new Object[]{value});
        String id = value.substring(0, argsStart);
        OptionalInt argCount = OptionalInt.absent();
        OptionalInt retCount = OptionalInt.absent();
        try {
            String args = value.substring(argsStart + 1, value.length());
            int argsSeparator = args.indexOf(44);
            if (argsSeparator >= 0) {
                String retCountStr;
                String argCountStr = args.substring(0, argsSeparator);
                if (!argCountStr.isEmpty()) {
                    argCount = OptionalInt.of(Integer.parseInt(argCountStr));
                }
                if (!(retCountStr = args.substring(argsSeparator + 1, args.length())).isEmpty()) {
                    retCount = OptionalInt.of(Integer.parseInt(retCountStr));
                }
            } else {
                argCount = OptionalInt.of(Integer.parseInt(args));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't parse args on token '" + value + "'", e);
        }
        output.appendSymbolCall(id, argCount, retCount);
    }

    @Override
    public IPostfixParserState.Result acceptChildResult(E result) {
        this.builder.appendSubList(result);
        return IPostfixParserState.Result.ACCEPTED;
    }

    @Override
    public E getResult() {
        return this.builder.build();
    }
}

