/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.parsing.node;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import info.openmods.calc.executable.BinaryOperator;
import info.openmods.calc.executable.Operator;
import info.openmods.calc.executable.UnaryOperator;
import info.openmods.calc.parsing.IValueParser;
import info.openmods.calc.parsing.node.DefaultExprNodeFactory;
import info.openmods.calc.parsing.node.IExprNode;
import info.openmods.calc.parsing.token.TokenUtils;
import info.openmods.calc.utils.MiscUtils;
import java.util.List;
import java.util.Map;

public class MappedExprNodeFactory<E>
extends DefaultExprNodeFactory<E> {
    private final Map<String, IBracketExprNodeFactory<E>> bracketFactories = Maps.newHashMap();
    private final Map<Operator<E>, IOpNodeFactory<E>> opFactories = Maps.newIdentityHashMap();

    public MappedExprNodeFactory(IValueParser<E> valueParser) {
        super(valueParser);
    }

    @Override
    public IExprNode<E> createBracketNode(String openingBracket, String closingBracket, List<IExprNode<E>> children) {
        TokenUtils.checkIsValidBracketPair(openingBracket, closingBracket);
        IBracketExprNodeFactory<E> nodeFactory = this.bracketFactories.get(openingBracket);
        return nodeFactory != null ? nodeFactory.create(children) : this.createDefaultBracketNode(openingBracket, closingBracket, children);
    }

    protected IExprNode<E> createDefaultBracketNode(String openingBracket, String closingBracket, List<IExprNode<E>> children) {
        return super.createBracketNode(openingBracket, closingBracket, (List)children);
    }

    @Override
    public IExprNode<E> createOpNode(Operator<E> op, List<IExprNode<E>> children) {
        IOpNodeFactory<E> nodeFactory = this.opFactories.get(op);
        return nodeFactory != null ? nodeFactory.create(children) : this.createDefaultOpNode(op, children);
    }

    protected IExprNode<E> createDefaultOpNode(Operator<E> op, List<IExprNode<E>> children) {
        return super.createOpNode(op, children);
    }

    public MappedExprNodeFactory<E> addFactory(String openingBracket, IBracketExprNodeFactory<E> factory) {
        MiscUtils.putOnce(this.bracketFactories, openingBracket, factory);
        return this;
    }

    public MappedExprNodeFactory<E> addFactory(BinaryOperator<E> op, final IBinaryExprNodeFactory<E> factory) {
        MiscUtils.putOnce(this.opFactories, op, new IOpNodeFactory<E>(){

            @Override
            public IExprNode<E> create(List<IExprNode<E>> children) {
                Preconditions.checkArgument((children.size() == 2 ? 1 : 0) != 0, (String)"Expected 2 children, got %s", (Object[])new Object[]{children});
                return factory.create(children.get(0), children.get(1));
            }
        });
        return this;
    }

    public MappedExprNodeFactory<E> addFactory(UnaryOperator<E> op, final IUnaryExprNodeFactory<E> factory) {
        MiscUtils.putOnce(this.opFactories, op, new IOpNodeFactory<E>(){

            @Override
            public IExprNode<E> create(List<IExprNode<E>> children) {
                Preconditions.checkArgument((children.size() == 1 ? 1 : 0) != 0, (String)"Expected one child, got %s", (Object[])new Object[]{children});
                return factory.create(children.get(0));
            }
        });
        return this;
    }

    public static interface IOpNodeFactory<E> {
        public IExprNode<E> create(List<IExprNode<E>> var1);
    }

    public static interface IUnaryExprNodeFactory<E> {
        public IExprNode<E> create(IExprNode<E> var1);
    }

    public static interface IBinaryExprNodeFactory<E> {
        public IExprNode<E> create(IExprNode<E> var1, IExprNode<E> var2);
    }

    public static interface IBracketExprNodeFactory<E> {
        public IExprNode<E> create(List<IExprNode<E>> var1);
    }
}

