/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.executable;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import info.openmods.calc.ExecutionErrorException;
import info.openmods.calc.Frame;
import info.openmods.calc.executable.IExecutable;
import info.openmods.calc.symbol.ISymbol;
import info.openmods.calc.utils.OptionalInt;

public class SymbolCall<E>
implements IExecutable<E> {
    public static final OptionalInt DEFAULT_ARG_COUNT = OptionalInt.absent();
    public static final OptionalInt DEFAULT_RET_COUNT = OptionalInt.absent();
    private final String id;
    private final OptionalInt argCount;
    private final OptionalInt returnCount;

    public SymbolCall(String id) {
        this(id, DEFAULT_ARG_COUNT, DEFAULT_RET_COUNT);
    }

    public SymbolCall(String id, int argumentCount, int returnCount) {
        this.id = id;
        this.argCount = OptionalInt.of(argumentCount);
        this.returnCount = OptionalInt.of(returnCount);
    }

    public SymbolCall(String id, OptionalInt argumentCount, OptionalInt returnCount) {
        this.id = id;
        this.argCount = argumentCount;
        this.returnCount = returnCount;
    }

    @Override
    public void execute(Frame<E> frame) {
        ISymbol<E> symbol = frame.symbols().get(this.id);
        Preconditions.checkNotNull(symbol, (String)"Unknown symbol: %s", (Object[])new Object[]{this.id});
        try {
            symbol.call(frame, this.argCount, this.returnCount);
        }
        catch (ExecutionErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to execute symbol '" + this.id + "'", e);
        }
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.argCount, this.returnCount});
    }

    public boolean equals(Object obj) {
        if (obj instanceof SymbolCall) {
            SymbolCall other = (SymbolCall)obj;
            return other.id.equals(this.id) && other.argCount.equals(this.argCount) && other.returnCount.equals(this.returnCount);
        }
        return false;
    }

    private static String printOptional(OptionalInt value) {
        return value.isPresent() ? String.valueOf(value.get()) : "?";
    }

    public String toString() {
        return this.id + "[-" + SymbolCall.printOptional(this.argCount) + "+" + SymbolCall.printOptional(this.returnCount) + "]";
    }
}

