/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.executable;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import info.openmods.calc.parsing.ast.IOperator;
import info.openmods.calc.parsing.ast.IOperatorDictionary;
import info.openmods.calc.parsing.ast.OperatorArity;
import java.util.Set;

public class OperatorDictionary<O extends IOperator<O>>
implements IOperatorDictionary<O> {
    private final Table<OperatorArity, String, O> operators = HashBasedTable.create();
    private O defaultOperator;

    public <T extends O> OperatorRegistration<T> registerOperator(T operator) {
        IOperator prev = (IOperator)this.operators.put((Object)operator.arity(), (Object)operator.id(), operator);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Duplicate operator '%s': %s -> %s", (Object[])new Object[]{prev, operator});
        return new OperatorRegistration(this, (IOperator)operator);
    }

    public <T extends O> T registerDefaultOperator(T operator) {
        this.setDefaultOperator(operator);
        return operator;
    }

    private void setDefaultOperator(O operator) {
        Preconditions.checkState((operator.arity() == OperatorArity.BINARY ? 1 : 0) != 0, (String)"Only binary operators can be default, trying to set %s", (Object[])new Object[]{operator});
        Preconditions.checkState((this.defaultOperator == null ? 1 : 0) != 0, (String)"Trying to replace default operator: %s -> %s", (Object[])new Object[]{this.defaultOperator, operator});
        this.defaultOperator = operator;
    }

    @Override
    public Set<String> allOperatorIds() {
        return this.operators.columnKeySet();
    }

    @Override
    public O getOperator(String op, OperatorArity arity) {
        return (O)((IOperator)this.operators.get((Object)arity, (Object)op));
    }

    @Override
    public O getDefaultOperator() {
        return this.defaultOperator;
    }

    public static class OperatorRegistration<T extends O> {
        private final T op;
        final /* synthetic */ OperatorDictionary this$0;

        private OperatorRegistration(T op) {
            this.this$0 = this$0;
            this.op = op;
        }

        public OperatorRegistration<T> setDefault() {
            this.this$0.setDefaultOperator(this.op);
            return this;
        }

        public T unwrap() {
            return this.op;
        }
    }
}

