/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.block.states;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import mekanism.common.Mekanism;
import mekanism.common.base.IBlockType;
import mekanism.common.block.states.BlockStateBasic;
import mekanism.common.block.states.BlockStateFacing;
import mekanism.common.config.MekanismConfig;
import mekanism.common.recipe.ShapedMekanismRecipe;
import mekanism.common.util.LangUtils;
import mekanism.generators.common.GeneratorsBlocks;
import mekanism.generators.common.block.BlockGenerator;
import mekanism.generators.common.tile.TileEntityAdvancedSolarGenerator;
import mekanism.generators.common.tile.TileEntityBioGenerator;
import mekanism.generators.common.tile.TileEntityGasGenerator;
import mekanism.generators.common.tile.TileEntityHeatGenerator;
import mekanism.generators.common.tile.TileEntitySolarGenerator;
import mekanism.generators.common.tile.TileEntityWindGenerator;
import mekanism.generators.common.tile.turbine.TileEntityElectromagneticCoil;
import mekanism.generators.common.tile.turbine.TileEntityRotationalComplex;
import mekanism.generators.common.tile.turbine.TileEntitySaturatingCondenser;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import mekanism.generators.common.tile.turbine.TileEntityTurbineRotor;
import mekanism.generators.common.tile.turbine.TileEntityTurbineValve;
import mekanism.generators.common.tile.turbine.TileEntityTurbineVent;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockStateGenerator
extends ExtendedBlockState {
    public static final PropertyBool activeProperty = PropertyBool.func_177716_a((String)"active");

    public BlockStateGenerator(BlockGenerator block, PropertyEnum typeProperty) {
        super((Block)block, new IProperty[]{BlockStateFacing.facingProperty, typeProperty, activeProperty}, new IUnlistedProperty[]{BlockStateBasic.ctmProperty});
    }

    public static class GeneratorBlockStateMapper
    extends StateMapperBase {
        protected ModelResourceLocation func_178132_a(IBlockState state) {
            BlockGenerator block = (BlockGenerator)state.func_177230_c();
            GeneratorType type = (GeneratorType)((Object)state.func_177229_b(block.getTypeProperty()));
            StringBuilder builder = new StringBuilder();
            String nameOverride = null;
            if (type.hasActiveTexture()) {
                builder.append(activeProperty.func_177701_a());
                builder.append("=");
                builder.append(state.func_177229_b((IProperty)activeProperty));
            }
            if (type.hasRotations()) {
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockStateFacing.facingProperty);
                if (!type.canRotateTo(facing)) {
                    facing = EnumFacing.NORTH;
                }
                if (builder.length() > 0) {
                    builder.append(",");
                }
                builder.append(BlockStateFacing.facingProperty.func_177701_a());
                builder.append("=");
                builder.append(facing.func_176610_l());
            }
            if (builder.length() == 0) {
                builder.append("normal");
            }
            ResourceLocation baseLocation = new ResourceLocation("mekanismgenerators", nameOverride != null ? nameOverride : type.func_176610_l());
            return new ModelResourceLocation(baseLocation, builder.toString());
        }
    }

    public static enum GeneratorType implements IStringSerializable,
    IBlockType
    {
        HEAT_GENERATOR(GeneratorBlock.GENERATOR_BLOCK_1, 0, "HeatGenerator", 0, 160000.0, TileEntityHeatGenerator.class, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, false),
        SOLAR_GENERATOR(GeneratorBlock.GENERATOR_BLOCK_1, 1, "SolarGenerator", 1, 96000.0, TileEntitySolarGenerator.class, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, false),
        GAS_GENERATOR(GeneratorBlock.GENERATOR_BLOCK_1, 3, "GasGenerator", 3, MekanismConfig.general.FROM_H2 * 100.0, TileEntityGasGenerator.class, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, false),
        BIO_GENERATOR(GeneratorBlock.GENERATOR_BLOCK_1, 4, "BioGenerator", 4, 160000.0, TileEntityBioGenerator.class, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, false),
        ADVANCED_SOLAR_GENERATOR(GeneratorBlock.GENERATOR_BLOCK_1, 5, "AdvancedSolarGenerator", 1, 200000.0, TileEntityAdvancedSolarGenerator.class, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, false),
        WIND_GENERATOR(GeneratorBlock.GENERATOR_BLOCK_1, 6, "WindGenerator", 5, 200000.0, TileEntityWindGenerator.class, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, false),
        TURBINE_ROTOR(GeneratorBlock.GENERATOR_BLOCK_1, 7, "TurbineRotor", -1, -1.0, TileEntityTurbineRotor.class, false, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false),
        ROTATIONAL_COMPLEX(GeneratorBlock.GENERATOR_BLOCK_1, 8, "RotationalComplex", -1, -1.0, TileEntityRotationalComplex.class, false, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false),
        ELECTROMAGNETIC_COIL(GeneratorBlock.GENERATOR_BLOCK_1, 9, "ElectromagneticCoil", -1, -1.0, TileEntityElectromagneticCoil.class, false, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false),
        TURBINE_CASING(GeneratorBlock.GENERATOR_BLOCK_1, 10, "TurbineCasing", -1, -1.0, TileEntityTurbineCasing.class, false, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false),
        TURBINE_VALVE(GeneratorBlock.GENERATOR_BLOCK_1, 11, "TurbineValve", -1, -1.0, TileEntityTurbineValve.class, false, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false),
        TURBINE_VENT(GeneratorBlock.GENERATOR_BLOCK_1, 12, "TurbineVent", -1, -1.0, TileEntityTurbineVent.class, false, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false),
        SATURATING_CONDENSER(GeneratorBlock.GENERATOR_BLOCK_1, 13, "SaturatingCondenser", -1, -1.0, TileEntitySaturatingCondenser.class, false, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false);

        public GeneratorBlock blockType;
        public int meta;
        public String blockName;
        public int guiId;
        public double maxEnergy;
        public Class<? extends TileEntity> tileEntityClass;
        public boolean hasModel;
        public Collection<ShapedMekanismRecipe> blockRecipes = new HashSet<ShapedMekanismRecipe>();
        public Predicate<EnumFacing> facingPredicate;
        public boolean activable;

        private GeneratorType(GeneratorBlock block, int i, String s, int j, double k, Class<? extends TileEntity> tileClass, boolean model, Predicate<EnumFacing> predicate, boolean hasActiveTexture) {
            this.blockType = block;
            this.meta = i;
            this.blockName = s;
            this.guiId = j;
            this.maxEnergy = k;
            this.tileEntityClass = tileClass;
            this.hasModel = model;
            this.facingPredicate = predicate;
            this.activable = hasActiveTexture;
        }

        public static List<GeneratorType> getGeneratorsForConfig() {
            ArrayList<GeneratorType> ret = new ArrayList<GeneratorType>();
            for (GeneratorType type : GeneratorType.values()) {
                if (type.ordinal() > 5) continue;
                ret.add(type);
            }
            return ret;
        }

        public String getBlockName() {
            return this.blockName;
        }

        public boolean isEnabled() {
            if (this.meta > GeneratorType.WIND_GENERATOR.meta) {
                return true;
            }
            return MekanismConfig.generators.generatorsManager.isEnabled(this.blockName);
        }

        public void addRecipes(Collection<ShapedMekanismRecipe> recipes) {
            this.blockRecipes.addAll(recipes);
        }

        public void addRecipe(ShapedMekanismRecipe recipe) {
            this.blockRecipes.add(recipe);
        }

        public Collection<ShapedMekanismRecipe> getRecipes() {
            return this.blockRecipes;
        }

        public static GeneratorType get(IBlockState state) {
            if (state.func_177230_c() instanceof BlockGenerator) {
                return (GeneratorType)((Object)state.func_177229_b(((BlockGenerator)state.func_177230_c()).getTypeProperty()));
            }
            return null;
        }

        public static GeneratorType get(Block block, int meta) {
            if (block instanceof BlockGenerator) {
                return GeneratorType.get(((BlockGenerator)block).getGeneratorBlock(), meta);
            }
            return null;
        }

        public static GeneratorType get(GeneratorBlock block, int meta) {
            for (GeneratorType type : GeneratorType.values()) {
                if (type.meta != meta || type.blockType != block) continue;
                return type;
            }
            return null;
        }

        public static GeneratorType get(ItemStack stack) {
            return GeneratorType.get(Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77952_i());
        }

        public TileEntity create() {
            try {
                return this.tileEntityClass.newInstance();
            }
            catch (Exception e) {
                Mekanism.logger.error("Unable to indirectly create tile entity.");
                e.printStackTrace();
                return null;
            }
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String getDescription() {
            return LangUtils.localize((String)("tooltip." + this.blockName));
        }

        public ItemStack getStack() {
            return new ItemStack(GeneratorsBlocks.Generator, 1, this.meta);
        }

        public boolean canRotateTo(EnumFacing side) {
            return this.facingPredicate.apply((Object)side);
        }

        public boolean hasRotations() {
            return !this.facingPredicate.equals((Object)Predicates.alwaysFalse());
        }

        public boolean hasActiveTexture() {
            return this.activable;
        }
    }

    public static class GeneratorBlockPredicate
    implements Predicate<GeneratorType> {
        public GeneratorBlock GeneratorBlock;

        public GeneratorBlockPredicate(GeneratorBlock type) {
            this.GeneratorBlock = type;
        }

        public boolean apply(GeneratorType input) {
            return input.blockType == this.GeneratorBlock;
        }
    }

    public static enum GeneratorBlock {
        GENERATOR_BLOCK_1;

        PropertyEnum<GeneratorType> generatorTypeProperty;

        public PropertyEnum<GeneratorType> getProperty() {
            if (this.generatorTypeProperty == null) {
                this.generatorTypeProperty = PropertyEnum.func_177708_a((String)"type", GeneratorType.class, (Predicate)new GeneratorBlockPredicate(this));
            }
            return this.generatorTypeProperty;
        }

        public Block getBlock() {
            switch (this) {
                case GENERATOR_BLOCK_1: {
                    return GeneratorsBlocks.Generator;
                }
            }
            return null;
        }
    }
}

