/*
 * Decompiled with CFR 0.152.
 */
package am2.world;

import am2.defs.BlockDefs;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class WitchwoodTreeSmall
extends WorldGenAbstractTree {
    private final int minTreeHeight = 4;
    private final IBlockState logBlock = BlockDefs.witchwoodLog.func_176223_P();
    private final IBlockState leafBlock = BlockDefs.witchwoodLeaves.func_176223_P();

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        int height = random.nextInt(3) + this.minTreeHeight;
        boolean isValidPlantingSpot = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + height + 1 <= 256) {
            int leafMaxRadius;
            for (int j = pos.func_177956_o(); j <= pos.func_177956_o() + 1 + height; ++j) {
                leafMaxRadius = 1;
                if (j == pos.func_177956_o()) {
                    leafMaxRadius = 0;
                }
                if (j >= pos.func_177956_o() + 1 + height - 2) {
                    leafMaxRadius = 2;
                }
                for (int i = pos.func_177958_n() - leafMaxRadius; i <= pos.func_177958_n() + leafMaxRadius && isValidPlantingSpot; ++i) {
                    for (int k = pos.func_177952_p() - leafMaxRadius; k <= pos.func_177952_p() + leafMaxRadius && isValidPlantingSpot; ++k) {
                        if (j >= 0 && j < 256) {
                            if (this.isReplaceable(world, new BlockPos(i, j, k))) continue;
                            isValidPlantingSpot = false;
                            continue;
                        }
                        isValidPlantingSpot = false;
                    }
                }
            }
            if (!isValidPlantingSpot) {
                return false;
            }
            Block block2 = world.func_180495_p(pos.func_177977_b()).func_177230_c();
            boolean isSoil = block2.canSustainPlant(world.func_180495_p(pos.func_177977_b()), (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (isSoil && pos.func_177956_o() < 256 - height - 1) {
                int j;
                block2.onPlantGrow(world.func_180495_p(pos.func_177977_b()), world, pos.func_177977_b(), pos);
                leafMaxRadius = 3;
                int b1 = 0;
                for (j = pos.func_177956_o() - leafMaxRadius + height; j <= pos.func_177956_o() + height; ++j) {
                    int treeHeightLayer = j - (pos.func_177956_o() + height);
                    int leafGenRadius = b1 + 1 - treeHeightLayer / 2;
                    for (int i = pos.func_177958_n() - leafGenRadius; i <= pos.func_177958_n() + leafGenRadius; ++i) {
                        int leafGenDeltaX = i - pos.func_177958_n();
                        for (int k = pos.func_177952_p() - leafGenRadius; k <= pos.func_177952_p() + leafGenRadius; ++k) {
                            BlockPos leafPos;
                            IBlockState block1;
                            int leafGenDeltaZ = k - pos.func_177952_p();
                            if (Math.abs(leafGenDeltaX) == leafGenRadius && Math.abs(leafGenDeltaZ) == leafGenRadius && (random.nextInt(2) == 0 || treeHeightLayer == 0) || !(block1 = world.func_180495_p(leafPos = new BlockPos(i, j, k))).func_177230_c().isAir(block1, (IBlockAccess)world, leafPos) && !block1.func_177230_c().isLeaves(block1, (IBlockAccess)world, leafPos)) continue;
                            world.func_175656_a(leafPos, this.leafBlock);
                        }
                    }
                }
                for (j = 0; j < height; ++j) {
                    IBlockState block = world.func_180495_p(pos.func_177982_a(0, j, 0));
                    if (!block.func_177230_c().isAir(block, (IBlockAccess)world, pos.func_177982_a(0, j, 0)) && !block.func_177230_c().isLeaves(block, (IBlockAccess)world, pos.func_177982_a(0, j, 0))) continue;
                    this.func_175903_a(world, pos.func_177982_a(0, j, 0), this.logBlock);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public WitchwoodTreeSmall(boolean par1) {
        super(par1);
    }
}

