/*
 * Decompiled with CFR 0.152.
 */
package am2.world;

import am2.ArsMagica2;
import am2.blocks.BlockArsMagicaOre;
import am2.defs.BlockDefs;
import am2.entity.SpawnBlacklists;
import am2.world.AM2FlowerGen;
import am2.world.AM2PoolGen;
import am2.world.WitchwoodTreeHuge;
import am2.world.WorldGenEssenceLakes;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.IWorldGenerator;

public class AM2WorldDecorator
implements IWorldGenerator {
    private final WorldGenMinable vinteum;
    private final WorldGenMinable blueTopaz;
    private final WorldGenMinable chimerite;
    private final WorldGenMinable sunstone;
    private final AM2FlowerGen blueOrchid;
    private final AM2FlowerGen desertNova;
    private final AM2FlowerGen wakebloom;
    private final AM2FlowerGen aum;
    private final AM2FlowerGen tarmaRoot;
    private ArrayList<Integer> dimensionBlacklist = new ArrayList();
    private final WitchwoodTreeHuge witchwoodTree;
    private final AM2PoolGen pools;

    public AM2WorldDecorator() {
        for (int i : ArsMagica2.config.getWorldgenBlacklist()) {
            if (i == -1) continue;
            this.dimensionBlacklist.add(i);
        }
        this.vinteum = new WorldGenMinable(BlockDefs.ores.func_176223_P().func_177226_a(BlockArsMagicaOre.ORE_TYPE, (Comparable)((Object)BlockArsMagicaOre.EnumOreType.VINTEUM)), 4, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
        this.chimerite = new WorldGenMinable(BlockDefs.ores.func_176223_P().func_177226_a(BlockArsMagicaOre.ORE_TYPE, (Comparable)((Object)BlockArsMagicaOre.EnumOreType.CHIMERITE)), 6, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
        this.blueTopaz = new WorldGenMinable(BlockDefs.ores.func_176223_P().func_177226_a(BlockArsMagicaOre.ORE_TYPE, (Comparable)((Object)BlockArsMagicaOre.EnumOreType.BLUETOPAZ)), 6, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
        this.sunstone = new WorldGenMinable(BlockDefs.ores.func_176223_P().func_177226_a(BlockArsMagicaOre.ORE_TYPE, (Comparable)((Object)BlockArsMagicaOre.EnumOreType.SUNSTONE)), 3, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150353_l));
        this.blueOrchid = new AM2FlowerGen(BlockDefs.cerublossom);
        this.desertNova = new AM2FlowerGen(BlockDefs.desertNova);
        this.wakebloom = new AM2FlowerGen(BlockDefs.wakebloom);
        this.aum = new AM2FlowerGen(BlockDefs.aum);
        this.tarmaRoot = new AM2FlowerGen(BlockDefs.tarmaRoot);
        this.witchwoodTree = new WitchwoodTreeHuge(true);
        this.pools = new AM2PoolGen();
        new WorldGenEssenceLakes(BlockDefs.liquid_essence.getBlock());
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!SpawnBlacklists.worldgenCanHappenInDimension(world.field_73011_w.getDimension())) {
            return;
        }
        if (world.func_72912_H().func_76067_t() == WorldType.field_77138_c) {
            return;
        }
        if (this.dimensionBlacklist.contains(world.field_73011_w.getDimension())) {
            return;
        }
        switch (world.field_73011_w.getDimension()) {
            case -1: {
                this.generateNether(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
                break;
            }
            case 1: {
                break;
            }
            default: {
                this.generateOverworld(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
            }
        }
    }

    public void generateNether(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateOre(this.sunstone, 20, world, random, 5, 120, chunkX, chunkZ);
    }

    public void generateOverworld(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateOre(this.vinteum, 6, world, random, 10, 45, chunkX, chunkZ);
        this.generateOre(this.chimerite, 8, world, random, 10, 80, chunkX, chunkZ);
        this.generateOre(this.blueTopaz, 8, world, random, 10, 80, chunkX, chunkZ);
        this.generateOre(this.sunstone, 20, world, random, 5, 120, chunkX, chunkZ);
        this.generateFlowers(this.blueOrchid, world, random, chunkX, chunkZ);
        this.generateFlowers(this.desertNova, world, random, chunkX, chunkZ);
        this.generateFlowers(this.tarmaRoot, world, random, chunkX, chunkZ);
        Biome biome = world.func_180494_b(new BlockPos(chunkX << 4, 0, chunkZ << 4));
        BiomeDictionary.Type[] biomeTypes = BiomeDictionary.getTypesForBiome((Biome)biome);
        boolean typeValid = false;
        for (BiomeDictionary.Type type : biomeTypes) {
            if (type == BiomeDictionary.Type.BEACH || type == BiomeDictionary.Type.SWAMP || type == BiomeDictionary.Type.JUNGLE || type == BiomeDictionary.Type.PLAINS || type == BiomeDictionary.Type.WATER) {
                typeValid = true;
                continue;
            }
            if (type != BiomeDictionary.Type.SNOWY) continue;
            typeValid = false;
            break;
        }
        if (biome != Biome.field_185377_q.func_82594_a((Object)new ResourceLocation("minecraft:ocean")) && typeValid && random.nextInt(10) < 7) {
            this.generateFlowers(this.wakebloom, world, random, chunkX, chunkZ);
        }
        if (random.nextInt(35) == 0) {
            this.generateTree((WorldGenerator)this.witchwoodTree, world, random, chunkX, chunkZ);
        }
        if (random.nextInt(25) == 0) {
            this.generatePools(world, random, chunkX, chunkZ);
        }
        if ((BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL) || BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) && random.nextInt(4) == 0 && TerrainGen.populate((IChunkGenerator)chunkGenerator, (World)world, (Random)random, (int)chunkX, (int)chunkZ, (boolean)true, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
            int lakeGenX = chunkX * 16 + random.nextInt(16) + 8;
            int lakeGenY = random.nextInt(128);
            int lakeGenZ = chunkZ * 16 + random.nextInt(16) + 8;
            new WorldGenEssenceLakes(BlockDefs.liquid_essence.getBlock()).func_180709_b(world, random, new BlockPos(lakeGenX, lakeGenY, lakeGenZ));
        }
    }

    private void generateFlowers(AM2FlowerGen flowers, World world, Random random, int chunkX, int chunkZ) {
        int x = (chunkX << 4) + random.nextInt(16) + 8;
        int y = random.nextInt(128);
        int z = (chunkZ << 4) + random.nextInt(16) + 8;
        flowers.func_180709_b(world, random, new BlockPos(x, y, z));
    }

    private void generateOre(WorldGenMinable mineable, int amount, World world, Random random, int minY, int maxY, int chunkX, int chunkZ) {
        for (int i = 0; i < amount; ++i) {
            int x = (chunkX << 4) + random.nextInt(16);
            int y = random.nextInt(maxY - minY) + minY;
            int z = (chunkZ << 4) + random.nextInt(16);
            mineable.func_180709_b(world, random, new BlockPos(x, y, z));
        }
    }

    private void generateTree(WorldGenerator trees, World world, Random random, int chunkX, int chunkZ) {
        int z;
        int x = chunkX * 16 + random.nextInt(16);
        BlockPos y = world.func_175645_m(new BlockPos(x, 0, z = chunkZ * 16 + random.nextInt(16)));
        if (new WitchwoodTreeHuge(true).func_180709_b(world, random, y)) {
            this.aum.func_180709_b(world, random, y);
        }
    }

    private void generatePools(World world, Random random, int chunkX, int chunkZ) {
        int x = chunkX * 16 + random.nextInt(16);
        int z = chunkZ * 16 + random.nextInt(16);
        BlockPos y = world.func_175645_m(new BlockPos(x, 0, z));
        this.pools.generate(world, random, y);
    }
}

