/*
 * Decompiled with CFR 0.152.
 */
package am2.world;

import am2.defs.BlockDefs;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class AM2PoolGen {
    public void generate(World world, Random rand, BlockPos pos) {
        if ((pos = this.correctYCoord(world, pos)).func_177956_o() == -1) {
            return;
        }
        if (this.validPoolLocation(world, pos)) {
            world.func_175656_a(pos, BlockDefs.liquid_essence.getBlock().func_176223_P());
            world.func_175656_a(pos.func_177982_a(-1, 0, 0), BlockDefs.liquid_essence.getBlock().func_176223_P());
            world.func_175656_a(pos.func_177982_a(0, 0, -1), BlockDefs.liquid_essence.getBlock().func_176223_P());
            world.func_175656_a(pos.func_177982_a(-1, 0, -1), BlockDefs.liquid_essence.getBlock().func_176223_P());
            world.func_175698_g(pos.func_177984_a());
            world.func_175698_g(pos.func_177982_a(-1, 0, 0).func_177984_a());
            world.func_175698_g(pos.func_177982_a(0, 0, -1).func_177984_a());
            world.func_175698_g(pos.func_177982_a(-1, 0, -1).func_177984_a());
        }
    }

    private BlockPos correctYCoord(World world, BlockPos pos) {
        while (pos.func_177956_o() > 0 && world.func_175623_d(pos)) {
            pos = pos.func_177977_b();
        }
        if (pos.func_177956_o() <= 0) {
            return new BlockPos(0, -1, 0);
        }
        while (pos.func_177956_o() < world.field_73011_w.getActualHeight() && !world.func_175623_d(pos.func_177984_a())) {
            pos = pos.func_177984_a();
        }
        if (pos.func_177956_o() > world.field_73011_w.getActualHeight()) {
            return new BlockPos(0, -1, 0);
        }
        return pos;
    }

    private boolean validPoolLocation(World world, BlockPos pos) {
        if (!this.biomeIsValid(world, pos)) {
            return false;
        }
        int radius = 2;
        IBlockState requiredBlock = world.func_180494_b((BlockPos)pos).field_76752_A;
        IBlockState alternateBlock = world.func_180494_b((BlockPos)pos).field_76753_B;
        if (requiredBlock == null || alternateBlock == null) {
            return false;
        }
        for (int i = -radius; i < radius; ++i) {
            for (int k = -radius; k < radius; ++k) {
                IBlockState blockBelow = world.func_180495_p(pos.func_177982_a(i, -1, k));
                IBlockState block = world.func_180495_p(pos.func_177982_a(i, 0, k));
                if (blockBelow == null || block == null) {
                    return false;
                }
                if (!blockBelow.func_185914_p()) {
                    return false;
                }
                if (block != requiredBlock && block != alternateBlock) {
                    return false;
                }
                IBlockState blockAbove = world.func_180495_p(pos.func_177984_a());
                if (blockAbove == null) continue;
                if (blockAbove.func_185914_p()) {
                    return false;
                }
                if (!blockAbove.func_185904_a().func_76230_c()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean biomeIsValid(World world, BlockPos pos) {
        BiomeDictionary.Type[] types;
        Biome biome = world.func_180494_b(pos);
        for (BiomeDictionary.Type type : types = BiomeDictionary.getTypesForBiome((Biome)biome)) {
            if (type != BiomeDictionary.Type.END && type != BiomeDictionary.Type.MUSHROOM && type != BiomeDictionary.Type.NETHER && type != BiomeDictionary.Type.WATER && type != BiomeDictionary.Type.WASTELAND) continue;
            return false;
        }
        return true;
    }
}

