/*
 * Decompiled with CFR 0.152.
 */
package am2.utils;

import am2.LogHelper;
import com.mojang.authlib.GameProfile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class SelectionUtils {
    public static int[] getRuneSet(EntityPlayer player) {
        long key = player.func_110124_au().getMostSignificantBits();
        return SelectionUtils.getRunesFromKey(key);
    }

    public static int[] getRunesFromKey(long key) {
        int size = 4;
        long checkKey = 65535L;
        boolean[] used = new boolean[16];
        int[] ids = new int[size];
        for (int i = 0; i < size; ++i) {
            long rune = key >> i * 16;
            if (((rune &= checkKey) & 1L) == 1L && !used[0]) {
                ids[i] = EnumDyeColor.BLACK.func_176767_b();
                used[0] = true;
                continue;
            }
            if ((rune & 2L) == 2L && !used[1]) {
                ids[i] = EnumDyeColor.BLUE.func_176767_b();
                used[1] = true;
                continue;
            }
            if ((rune & 4L) == 4L && !used[2]) {
                ids[i] = EnumDyeColor.BROWN.func_176767_b();
                used[2] = true;
                continue;
            }
            if ((rune & 8L) == 8L && !used[3]) {
                ids[i] = EnumDyeColor.CYAN.func_176767_b();
                used[3] = true;
                continue;
            }
            if ((rune & 0x10L) == 16L && !used[4]) {
                ids[i] = EnumDyeColor.GRAY.func_176767_b();
                used[4] = true;
                continue;
            }
            if ((rune & 0x20L) == 32L && !used[5]) {
                ids[i] = EnumDyeColor.GREEN.func_176767_b();
                used[5] = true;
                continue;
            }
            if ((rune & 0x40L) == 64L && !used[6]) {
                ids[i] = EnumDyeColor.LIGHT_BLUE.func_176767_b();
                used[6] = true;
                continue;
            }
            if ((rune & 0x80L) == 128L && !used[7]) {
                ids[i] = EnumDyeColor.SILVER.func_176767_b();
                used[7] = true;
                continue;
            }
            if ((rune & 0x100L) == 256L && !used[8]) {
                ids[i] = EnumDyeColor.LIME.func_176767_b();
                used[8] = true;
                continue;
            }
            if ((rune & 0x200L) == 512L && !used[9]) {
                ids[i] = EnumDyeColor.MAGENTA.func_176767_b();
                used[9] = true;
                continue;
            }
            if ((rune & 0x400L) == 1024L && !used[10]) {
                ids[i] = EnumDyeColor.ORANGE.func_176767_b();
                used[10] = true;
                continue;
            }
            if ((rune & 0x800L) == 2048L && !used[11]) {
                ids[i] = EnumDyeColor.PINK.func_176767_b();
                used[11] = true;
                continue;
            }
            if ((rune & 0x1000L) == 4096L && !used[12]) {
                ids[i] = EnumDyeColor.PURPLE.func_176767_b();
                used[12] = true;
                continue;
            }
            if ((rune & 0x2000L) == 8192L && !used[13]) {
                ids[i] = EnumDyeColor.RED.func_176767_b();
                used[13] = true;
                continue;
            }
            if ((rune & 0x4000L) == 16384L && !used[14]) {
                ids[i] = EnumDyeColor.WHITE.func_176767_b();
                used[14] = true;
                continue;
            }
            if ((rune & 0x8000L) != 32768L || used[15]) continue;
            ids[i] = EnumDyeColor.YELLOW.func_176767_b();
            used[15] = true;
        }
        return ids;
    }

    public static EntityPlayer getPlayersForRuneSet(int[] runes) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        GameProfile[] profiles = server.func_184103_al().func_152600_g();
        if (runes.length != 4) {
            return null;
        }
        for (GameProfile profile : profiles) {
            EntityPlayer player = server.func_130014_f_().func_152378_a(profile.getId());
            boolean match = true;
            for (int i = 0; i < 4; ++i) {
                if (SelectionUtils.getRuneSet(player)[i] == runes[i]) continue;
                match = false;
            }
            if (match) {
                return player;
            }
            if (player != null) continue;
            LogHelper.error("Missing player " + profile.getName(), new Object[0]);
        }
        return null;
    }
}

