/*
 * Decompiled with CFR 0.152.
 */
package am2.utils;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.Vec3d;

public class NBTUtils {
    public static NBTTagCompound getAM2Tag(NBTTagCompound baseTag) {
        return NBTUtils.addTag(baseTag, "AM2");
    }

    public static NBTTagCompound getEssenceTag(NBTTagCompound baseTag) {
        return NBTUtils.addTag(NBTUtils.getAM2Tag(baseTag), "Essence");
    }

    public static void writeVecToNBT(Vec3d vec, NBTTagCompound nbt) {
        nbt.func_74780_a("X", vec.field_72450_a);
        nbt.func_74780_a("Y", vec.field_72448_b);
        nbt.func_74780_a("Z", vec.field_72449_c);
    }

    public static Vec3d readVecFromNBT(NBTTagCompound nbt) {
        Vec3d vec = new Vec3d(nbt.func_74769_h("X"), nbt.func_74769_h("Y"), nbt.func_74769_h("Z"));
        return vec;
    }

    public static Object getValueAt(NBTTagCompound baseTag, String tagName) {
        NBTBase base = baseTag.func_74781_a(tagName);
        switch (base.func_74732_a()) {
            case 0: {
                return null;
            }
            case 1: {
                return ((NBTTagByte)base).func_150290_f();
            }
            case 2: {
                return ((NBTTagShort)base).func_150289_e();
            }
            case 3: {
                return ((NBTTagInt)base).func_150287_d();
            }
            case 4: {
                return ((NBTTagLong)base).func_150291_c();
            }
            case 5: {
                return Float.valueOf(((NBTTagFloat)base).func_150288_h());
            }
            case 6: {
                return ((NBTTagDouble)base).func_150286_g();
            }
            case 7: {
                return ((NBTTagByteArray)base).func_150292_c();
            }
            case 8: {
                return ((NBTTagString)base).func_150285_a_();
            }
            case 9: {
                return (NBTTagCompound)base;
            }
            case 10: {
                return ((NBTTagIntArray)base).func_150302_c();
            }
        }
        return null;
    }

    public static NBTTagCompound addTag(NBTTagCompound upper, String name) {
        if (upper == null) {
            throw new IllegalStateException("Base Tag must exist");
        }
        NBTTagCompound newTag = new NBTTagCompound();
        if (upper.func_74775_l(name) != null) {
            newTag = upper.func_74775_l(name);
        }
        upper.func_74782_a(name, (NBTBase)newTag);
        return newTag;
    }

    public static NBTTagCompound addTag(NBTTagCompound upper, NBTTagCompound compound, String name) {
        if (upper == null) {
            throw new IllegalStateException("Base Tag must exist");
        }
        upper.func_74782_a(name, (NBTBase)compound);
        return upper;
    }

    public static NBTTagList addList(NBTTagCompound upper, int type, String name) {
        if (upper == null) {
            throw new IllegalStateException("Base Tag must exist");
        }
        NBTTagList newTag = new NBTTagList();
        if (upper.func_150295_c(name, type) != null) {
            newTag = upper.func_150295_c(name, type);
        }
        upper.func_74782_a(name, (NBTBase)newTag);
        return newTag;
    }

    public static NBTTagList addCompoundList(NBTTagCompound upper, String name) {
        return NBTUtils.addList(upper, 10, name);
    }

    public static boolean contains(NBTTagCompound container, NBTTagCompound check) {
        if (container == null) {
            return true;
        }
        if (check == null) {
            return false;
        }
        boolean match = true;
        for (String key : container.func_150296_c()) {
            NBTBase tag = container.func_74781_a(key);
            NBTBase checkTag = check.func_74781_a(key);
            if (tag == null) continue;
            if (checkTag == null) {
                return false;
            }
            match = tag instanceof NBTTagCompound && checkTag instanceof NBTTagCompound ? (match &= NBTUtils.contains((NBTTagCompound)tag, (NBTTagCompound)checkTag)) : (match &= tag.equals((Object)checkTag));
            if (match) continue;
            break;
        }
        return match;
    }

    public static ItemStack[] getItemStackArray(NBTTagCompound tagCompound, String string) {
        NBTTagList list = NBTUtils.addCompoundList(tagCompound, string);
        ItemStack[] array = new ItemStack[list.func_74745_c()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tmp = list.func_150305_b(i);
            array[tmp.func_74762_e((String)"ID")] = ItemStack.func_77949_a((NBTTagCompound)tmp);
        }
        return array;
    }

    public static void setItemStackArray(NBTTagCompound tagCompound, String string, ItemStack[] recipeData) {
        NBTTagList list = NBTUtils.addCompoundList(tagCompound, string);
        for (int i = 0; i < recipeData.length; ++i) {
            NBTTagCompound tmp = new NBTTagCompound();
            tmp.func_74768_a("ID", i);
            recipeData[i].func_77955_b(tmp);
            list.func_74742_a((NBTBase)tmp);
        }
        tagCompound.func_74782_a(string, (NBTBase)list);
    }
}

