/*
 * Decompiled with CFR 0.152.
 */
package am2.utils;

import am2.ArsMagica2;
import am2.api.math.AMVector3;
import am2.blocks.tileentity.TileEntitySummoner;
import am2.entity.ai.EntityAIGuardSpawnLocation;
import am2.entity.ai.EntityAISummonFollowOwner;
import am2.entity.ai.selectors.SummonEntitySelector;
import am2.extensions.EntityExtension;
import com.google.common.base.Predicate;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class EntityUtils {
    private static final HashMap<Integer, ArrayList<EntityAITasks.EntityAITaskEntry>> storedTasks = new HashMap();
    private static final HashMap<Integer, ArrayList<EntityAITasks.EntityAITaskEntry>> storedAITasks = new HashMap();
    private static final String isSummonKey = "AM2_Entity_Is_Made_Summon";
    private static final String summonDurationKey = "AM2_Summon_Duration";
    private static final String summonOwnerKey = "AM2_Summon_Owner";
    private static Method ptrSetSize = null;
    private static final String summonTileXKey = "AM2_Summon_Tile_X";
    private static final String summonTileYKey = "AM2_Summon_Tile_Y";
    private static final String summonTileZKey = "AM2_Summon_Tile_Z";

    public static int getLevelFromXP(float totalXP) {
        int cap;
        int level = 0;
        int xp = (int)Math.floor(totalXP);
        while ((xp -= (cap = EntityUtils.xpBarCap(level))) >= 0) {
            ++level;
        }
        return level;
    }

    public static Entity getPointedEntity(World world, EntityLivingBase entityplayer, double range, double collideRadius, boolean nonCollide, boolean targetWater) {
        Entity pointedEntity = null;
        double d = range;
        Vec3d vec3d = new Vec3d(entityplayer.field_70165_t, entityplayer.field_70163_u + (double)entityplayer.func_70047_e(), entityplayer.field_70161_v);
        Vec3d vec3d1 = entityplayer.func_70040_Z();
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * d, vec3d1.field_72448_b * d, vec3d1.field_72449_c * d);
        double f1 = collideRadius;
        List list = world.func_72839_b((Entity)entityplayer, entityplayer.func_174813_aQ().func_72321_a(vec3d1.field_72450_a * d, vec3d1.field_72448_b * d, vec3d1.field_72449_c * d).func_72314_b(f1, f1, f1));
        double d2 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d3;
            Entity entity = (Entity)list.get(i);
            RayTraceResult mop = world.func_147447_a(new Vec3d(entityplayer.field_70165_t, entityplayer.field_70163_u + (double)entityplayer.func_70047_e(), entityplayer.field_70161_v), new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), targetWater, !targetWater, false);
            if (!entity.func_70067_L() && !nonCollide || mop != null) continue;
            float f2 = Math.max(0.8f, entity.func_70111_Y());
            AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72314_b((double)f2, (double)f2, (double)f2);
            RayTraceResult movingobjectposition = axisalignedbb.func_72327_a(vec3d, vec3d2);
            if (axisalignedbb.func_72318_a(vec3d)) {
                if (!(0.0 < d2) && d2 != 0.0) continue;
                pointedEntity = entity;
                d2 = 0.0;
                continue;
            }
            if (movingobjectposition == null || !((d3 = vec3d.func_72438_d(movingobjectposition.field_72307_f)) < d2) && d2 != 0.0) continue;
            pointedEntity = entity;
            d2 = d3;
        }
        return pointedEntity;
    }

    public static int getXPFromLevel(int level) {
        int totalXP = 0;
        for (int i = 0; i < level; ++i) {
            totalXP += EntityUtils.xpBarCap(i);
        }
        return totalXP;
    }

    public static int xpBarCap(int experienceLevel) {
        return experienceLevel >= 30 ? 112 + (experienceLevel - 30) * 9 : (experienceLevel >= 15 ? 37 + (experienceLevel - 15) * 5 : 7 + experienceLevel * 2);
    }

    public static boolean isAIEnabled(EntityCreature ent) {
        return !ent.func_175446_cd();
    }

    public static void makeSummon_PlayerFaction(EntityCreature entityliving, EntityPlayer player, boolean storeForRevert) {
        if (EntityUtils.isAIEnabled(entityliving) && EntityExtension.For((EntityLivingBase)player).getCurrentSummons() < EntityExtension.For((EntityLivingBase)player).getMaxSummons()) {
            if (storeForRevert) {
                storedTasks.put(entityliving.func_145782_y(), new ArrayList(entityliving.field_70715_bh.field_75782_a));
            }
            boolean addMeleeAttack = false;
            ArrayList<EntityAITasks.EntityAITaskEntry> toRemove = new ArrayList<EntityAITasks.EntityAITaskEntry>();
            for (Object task : entityliving.field_70714_bg.field_75782_a) {
                EntityAITasks.EntityAITaskEntry base = (EntityAITasks.EntityAITaskEntry)task;
                if (!(base.field_75733_a instanceof EntityAIAttackMelee)) continue;
                toRemove.add(base);
                addMeleeAttack = true;
            }
            entityliving.field_70714_bg.field_75782_a.removeAll(toRemove);
            if (storeForRevert) {
                storedAITasks.put(entityliving.func_145782_y(), toRemove);
            }
            if (addMeleeAttack) {
                float speed = entityliving.func_70689_ay();
                if (speed <= 0.0f) {
                    speed = 1.0f;
                }
                entityliving.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee(entityliving, (double)speed, true));
            }
            entityliving.field_70715_bh.field_75782_a.clear();
            entityliving.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget(entityliving, true, new Class[0]));
            entityliving.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget(entityliving, EntityMob.class, 0, true, false, (Predicate)SummonEntitySelector.instance));
            entityliving.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget(entityliving, EntitySlime.class, true));
            entityliving.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget(entityliving, EntityGhast.class, true));
            entityliving.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget(entityliving, EntityShulker.class, true));
            if (!entityliving.field_70170_p.field_72995_K && entityliving.func_70638_az() != null && entityliving.func_70638_az() instanceof EntityPlayer) {
                ArsMagica2.proxy.addDeferredTargetSet((EntityLiving)entityliving, null);
            }
            if (entityliving instanceof EntityTameable) {
                ((EntityTameable)entityliving).func_70903_f(true);
                ((EntityTameable)entityliving).func_184754_b(player.getPersistentID());
            }
            entityliving.getEntityData().func_74757_a(isSummonKey, true);
            EntityExtension.For((EntityLivingBase)player).addSummon(entityliving);
        }
    }

    public static boolean isSummon(EntityLivingBase entityliving) {
        return entityliving.getEntityData().func_74767_n(isSummonKey);
    }

    public static void makeSummon_MonsterFaction(EntityCreature entityliving, boolean storeForRevert) {
        if (EntityUtils.isAIEnabled(entityliving)) {
            if (storeForRevert) {
                storedTasks.put(entityliving.func_145782_y(), new ArrayList(entityliving.field_70715_bh.field_75782_a));
            }
            entityliving.field_70715_bh.field_75782_a.clear();
            entityliving.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget(entityliving, true, new Class[0]));
            entityliving.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget(entityliving, EntityPlayer.class, true));
            if (!entityliving.field_70170_p.field_72995_K && entityliving.func_70638_az() != null && entityliving.func_70638_az() instanceof EntityMob) {
                ArsMagica2.proxy.addDeferredTargetSet((EntityLiving)entityliving, null);
            }
            entityliving.getEntityData().func_74757_a(isSummonKey, true);
        }
    }

    public static void setOwner(EntityLivingBase entityliving, EntityLivingBase owner) {
        if (owner == null) {
            entityliving.getEntityData().func_82580_o(summonOwnerKey);
            return;
        }
        entityliving.getEntityData().func_74768_a(summonOwnerKey, owner.func_145782_y());
        if (entityliving instanceof EntityCreature) {
            float speed = entityliving.func_70689_ay();
            if (speed <= 0.0f) {
                speed = 1.0f;
            }
            ((EntityCreature)entityliving).field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISummonFollowOwner((EntityCreature)entityliving, speed, 10.0f, 20.0f));
        }
    }

    public static void setSummonDuration(EntityLivingBase entity, int duration) {
        entity.getEntityData().func_74768_a(summonDurationKey, duration);
    }

    public static int getOwner(EntityLivingBase entityliving) {
        if (!EntityUtils.isSummon(entityliving)) {
            return -1;
        }
        Integer ownerID = entityliving.getEntityData().func_74762_e(summonOwnerKey);
        return ownerID == null ? -1 : ownerID;
    }

    public static boolean revertAI(EntityCreature entityliving) {
        int ownerID = EntityUtils.getOwner((EntityLivingBase)entityliving);
        Entity owner = entityliving.field_70170_p.func_73045_a(ownerID);
        if (owner != null && owner instanceof EntityLivingBase) {
            EntityExtension.For((EntityLivingBase)owner).removeSummon();
            if (EntityExtension.For((EntityLivingBase)owner).isManaLinkedTo((EntityLivingBase)entityliving)) {
                EntityExtension.For((EntityLivingBase)owner).updateManaLink((EntityLivingBase)entityliving);
            }
        }
        entityliving.getEntityData().func_74757_a(isSummonKey, false);
        EntityUtils.setOwner((EntityLivingBase)entityliving, null);
        if (storedTasks.containsKey(entityliving.func_145782_y())) {
            entityliving.field_70715_bh.field_75782_a.clear();
            entityliving.field_70715_bh.field_75782_a.addAll((Collection)storedTasks.get(entityliving.func_145782_y()));
            storedTasks.remove(entityliving.func_145782_y());
            if (storedAITasks.get(entityliving.func_145782_y()) != null) {
                ArrayList<EntityAITasks.EntityAITaskEntry> toRemove = new ArrayList<EntityAITasks.EntityAITaskEntry>();
                for (Object task : entityliving.field_70714_bg.field_75782_a) {
                    EntityAITasks.EntityAITaskEntry base = (EntityAITasks.EntityAITaskEntry)task;
                    if (!(base.field_75733_a instanceof EntityAIAttackMelee) && !(base.field_75733_a instanceof EntityAISummonFollowOwner)) continue;
                    toRemove.add(base);
                }
                entityliving.field_70714_bg.field_75782_a.removeAll(toRemove);
                entityliving.field_70714_bg.field_75782_a.addAll((Collection)storedAITasks.get(entityliving.func_145782_y()));
                storedAITasks.remove(entityliving.func_145782_y());
            }
            if (!entityliving.field_70170_p.field_72995_K && entityliving.func_70638_az() != null) {
                ArsMagica2.proxy.addDeferredTargetSet((EntityLiving)entityliving, null);
            }
            if (entityliving instanceof EntityTameable) {
                ((EntityTameable)entityliving).func_70903_f(false);
            }
            return true;
        }
        return false;
    }

    public static boolean canBlockDamageSource(EntityLivingBase living, DamageSource damageSourceIn) {
        Vec3d vec3d;
        if (!damageSourceIn.func_76363_c() && (vec3d = damageSourceIn.func_188404_v()) != null) {
            Vec3d vec3d1 = living.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(living.field_70165_t, living.field_70163_u, living.field_70161_v)).func_72432_b();
            vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            if (vec3d2.func_72430_b(vec3d1) < 0.0) {
                return true;
            }
        }
        return false;
    }

    public static void setSize(EntityLivingBase entityliving, float width, float height) {
        if (entityliving.field_70130_N == width && entityliving.field_70131_O == height) {
            return;
        }
        if (ptrSetSize == null) {
            try {
                ptrSetSize = ReflectionHelper.findMethod(Entity.class, (Object)entityliving, (String[])new String[]{"func_70105_a", "setSize"}, (Class[])new Class[]{Float.TYPE, Float.TYPE});
            }
            catch (Throwable t) {
                t.printStackTrace();
                return;
            }
        }
        if (ptrSetSize != null) {
            try {
                ptrSetSize.setAccessible(true);
                ptrSetSize.invoke((Object)entityliving, Float.valueOf(width), Float.valueOf(height));
            }
            catch (Throwable t) {
                t.printStackTrace();
                return;
            }
        }
    }

    public static Vec3d correctLook(Vec3d vecIn, Entity entityIn) {
        if (entityIn instanceof EntityLivingBase && EntityExtension.For((EntityLivingBase)entityIn).isInverted()) {
            return new Vec3d(-vecIn.field_72450_a, -vecIn.field_72448_b, vecIn.field_72449_c);
        }
        return vecIn;
    }

    public static float correctEyePos(float floatIn, Entity entityIn) {
        float curHeight = floatIn;
        if (entityIn instanceof EntityPlayer && EntityExtension.For((EntityLivingBase)entityIn).isInverted()) {
            EntityPlayer player = (EntityPlayer)entityIn;
            curHeight = player.field_70131_O - floatIn - 0.1f;
        }
        if (entityIn instanceof EntityLivingBase && EntityExtension.For((EntityLivingBase)((EntityLivingBase)entityIn)).shrinkAmount != 0.0f) {
            curHeight *= EntityExtension.For((EntityLivingBase)((EntityLivingBase)entityIn)).shrinkAmount;
        }
        return curHeight;
    }

    public static boolean correctMouvement(float strafe, float forward, float friction, Entity entityIn) {
        if (entityIn instanceof EntityPlayer && EntityExtension.For((EntityLivingBase)entityIn).isInverted()) {
            float f = strafe * strafe + forward * forward;
            if (f >= 1.0E-4f) {
                if ((f = MathHelper.func_76129_c((float)f)) < 1.0f) {
                    f = 1.0f;
                }
                f = friction / f;
                float f1 = MathHelper.func_76126_a((float)(-entityIn.field_70177_z * ((float)Math.PI / 180)));
                float f2 = MathHelper.func_76134_b((float)(-entityIn.field_70177_z * ((float)Math.PI / 180)));
                entityIn.field_70159_w += (double)((strafe *= f) * f2 - (forward *= f) * f1);
                entityIn.field_70179_y += (double)(forward * f2 + strafe * f1);
            }
            return true;
        }
        return false;
    }

    public static void setTileSpawned(EntityLivingBase entityliving, TileEntitySummoner summoner) {
        entityliving.getEntityData().func_74768_a(summonTileXKey, summoner.func_174877_v().func_177958_n());
        entityliving.getEntityData().func_74768_a(summonTileYKey, summoner.func_174877_v().func_177956_o());
        entityliving.getEntityData().func_74768_a(summonTileZKey, summoner.func_174877_v().func_177952_p());
    }

    public static void setGuardSpawnLocation(EntityCreature entity, double x, double y, double z) {
        float speed = entity.func_70689_ay();
        if (speed <= 0.0f) {
            speed = 1.0f;
        }
        entity.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIGuardSpawnLocation(entity, speed, 3.0f, 16.0f, new AMVector3(x, y, z)));
    }

    public static int deductXP(int amount, EntityPlayer player) {
        int toAdd;
        int i = player.field_71067_cb;
        if (amount > i) {
            amount = i;
        }
        player.field_71067_cb -= amount;
        player.field_71106_cc = 0.0f;
        player.field_71068_ca = 0;
        for (int addedXP = 0; addedXP < player.field_71067_cb; addedXP += toAdd) {
            toAdd = player.field_71067_cb - addedXP;
            toAdd = Math.min(toAdd, player.func_71050_bK());
            player.field_71106_cc = (float)toAdd / (float)player.func_71050_bK();
            if (player.field_71106_cc != 1.0f) continue;
            ++player.field_71068_ca;
            player.field_71106_cc = 0.0f;
        }
        return amount;
    }
}

