/*
 * Decompiled with CFR 0.152.
 */
package am2.trackers;

import am2.ArsMagica2;
import am2.armor.ArmorHelper;
import am2.enchantments.AMEnchantments;
import am2.packet.AMDataWriter;
import am2.packet.AMNetHandler;
import am2.proxy.tick.ServerTickHandler;
import am2.utils.EntityUtils;
import am2.utils.WebRequestUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import scala.actors.threadpool.Arrays;

public class PlayerTracker {
    public static HashMap<UUID, HashMap<Integer, ItemStack>> soulbound_Storage;
    private TreeMap<String, Integer> aals;
    private TreeMap<String, String> clls;
    private TreeMap<String, Integer> cldm;

    public PlayerTracker() {
        soulbound_Storage = new HashMap();
        this.aals = new TreeMap();
        this.clls = new TreeMap();
        this.cldm = new TreeMap();
    }

    public void postInit() {
        this.populateAALList();
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (this.hasAA(event.player)) {
            AMNetHandler.INSTANCE.requestClientAuras((EntityPlayerMP)event.player);
        }
        ArsMagica2.disabledSkills.getDisabledSkills(true);
        int[] disabledSkills = ArsMagica2.disabledSkills.getDisabledSkillIDs();
        AMDataWriter writer = new AMDataWriter();
        writer.add(ArsMagica2.config.getSkillTreeSecondaryTierCap()).add(disabledSkills);
        writer.add(ArsMagica2.config.getManaCap());
        byte[] data = writer.generate();
        AMNetHandler.INSTANCE.syncLoginData((EntityPlayerMP)event.player, data);
        if (ServerTickHandler.lastWorldName != null) {
            AMNetHandler.INSTANCE.syncWorldName((EntityPlayerMP)event.player, ServerTickHandler.lastWorldName);
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            List list = event.player.field_70170_p.field_72996_f;
            for (Object o : list) {
                if (!(o instanceof EntityLivingBase) || !EntityUtils.isSummon((EntityLivingBase)o) || EntityUtils.getOwner((EntityLivingBase)o) != event.player.func_145782_y()) continue;
                ((EntityLivingBase)o).func_70106_y();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (soulbound_Storage.containsKey(event.player.func_110124_au())) {
            HashMap<Integer, ItemStack> soulboundItems = soulbound_Storage.get(event.player.func_110124_au());
            for (Integer i : soulboundItems.keySet()) {
                if (i < event.player.field_71071_by.func_70302_i_()) {
                    event.player.field_71071_by.func_70299_a(i.intValue(), soulboundItems.get(i));
                    continue;
                }
                event.player.func_70099_a(soulboundItems.get(i), 0.0f);
            }
        }
        ArsMagica2.disabledSkills.getDisabledSkills(true);
        int[] disabledSkills = ArsMagica2.disabledSkills.getDisabledSkillIDs();
        AMDataWriter writer = new AMDataWriter();
        writer.add(ArsMagica2.config.getSkillTreeSecondaryTierCap()).add(disabledSkills);
        writer.add(ArsMagica2.config.getManaCap());
        byte[] data = writer.generate();
        AMNetHandler.INSTANCE.syncLoginData((EntityPlayerMP)event.player, data);
        if (ServerTickHandler.lastWorldName != null) {
            AMNetHandler.INSTANCE.syncWorldName((EntityPlayerMP)event.player, ServerTickHandler.lastWorldName);
        }
    }

    public void onPlayerDeath(EntityPlayer player) {
        PlayerTracker.storeSoulboundItemsForRespawn(player);
    }

    public static void storeSoulboundItemsForRespawn(EntityPlayer player) {
        int soulbound_level;
        if (soulbound_Storage.containsKey(player.func_110124_au())) {
            soulbound_Storage.remove(player.func_110124_au());
        }
        HashMap<Integer, ItemStack> soulboundItems = new HashMap<Integer, ItemStack>();
        int slotCount = 0;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            soulbound_level = EnchantmentHelper.func_77506_a((Enchantment)AMEnchantments.soulbound, (ItemStack)stack);
            if (soulbound_level > 0) {
                soulboundItems.put(slotCount, stack.func_77946_l());
                player.field_71071_by.func_70299_a(slotCount, null);
            }
            ++slotCount;
        }
        slotCount = 0;
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            soulbound_level = EnchantmentHelper.func_77506_a((Enchantment)AMEnchantments.soulbound, (ItemStack)stack);
            if (soulbound_level > 0 || ArmorHelper.isInfusionPreset(stack, "soulbnd")) {
                soulboundItems.put(slotCount + player.field_71071_by.field_70462_a.length, stack.func_77946_l());
                player.field_71071_by.func_70299_a(slotCount + player.field_71071_by.field_70462_a.length, null);
            }
            ++slotCount;
        }
        soulbound_Storage.put(player.func_110124_au(), soulboundItems);
    }

    public static void storeSoulboundItemForRespawn(EntityPlayer player, ItemStack stack) {
        if (!soulbound_Storage.containsKey(player.func_110124_au())) {
            return;
        }
        HashMap<Integer, ItemStack> soulboundItems = soulbound_Storage.get(player.func_110124_au());
        int slotTest = 0;
        while (soulboundItems.containsKey(slotTest)) {
            if (++slotTest != player.field_71071_by.field_70462_a.length) continue;
            slotTest += player.field_71071_by.field_70460_b.length;
        }
        soulboundItems.put(slotTest, stack);
    }

    public boolean hasAA(EntityPlayer entity) {
        return this.getAAL(entity) > 0;
    }

    public int getAAL(EntityPlayer thePlayer) {
        try {
            thePlayer.func_145748_c_();
        }
        catch (Throwable t) {
            return 0;
        }
        if (this.aals == null || this.clls == null) {
            this.populateAALList();
        }
        if (this.aals.containsKey(thePlayer.func_145748_c_().func_150260_c().toLowerCase())) {
            return this.aals.get(thePlayer.func_145748_c_().func_150260_c().toLowerCase());
        }
        return 0;
    }

    private ArrayList<String> addContributors(ArrayList<String> lines) {
        lines.add("95ca1edb-b0d6-46a8-825d-2299763f03f0, :AL,3, :CL,http://i.imgur.com/QBCa5O0.png,6,growlith1223");
        lines.add("6b93546d-100a-403d-b352-f2bf75fd3b0c, :AL,3 :CL,http://i.imgur.com/QBCa5O0.png,6,jjtparadox");
        return lines;
    }

    private void populateAALList() {
        this.aals = new TreeMap();
        this.clls = new TreeMap();
        this.cldm = new TreeMap();
        String dls = "http://qorconcept.com/mc/AREW0152.txt";
        char[] dl = dls.toCharArray();
        try {
            String s = WebRequestUtils.sendPost(new String(dl), new HashMap<String, String>());
            ArrayList<String> lines = new ArrayList<String>(Arrays.asList((Object[])s.replace("\r\n", "\n").split("\n")));
            this.addContributors(lines);
            for (String line : lines) {
                String[] split = line.split(",");
                for (int i = 1; i < split.length; ++i) {
                    if (split[i].equals(":AL")) {
                        try {
                            this.aals.put(split[0].toLowerCase(), Integer.parseInt(split[i + 1]));
                        }
                        catch (Throwable throwable) {}
                        continue;
                    }
                    if (!split[i].equals(":CL")) continue;
                    try {
                        this.clls.put(split[0].toLowerCase(), split[i + 1]);
                        this.cldm.put(split[0].toLowerCase(), Integer.parseInt(split[i + 2]));
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getCLF(String uuid) {
        return this.clls.get(uuid.toLowerCase());
    }

    public boolean hasCLS(String uuid) {
        return this.clls.containsKey(uuid.toLowerCase());
    }

    public boolean hasCLDM(String uuid) {
        return this.cldm.containsKey(uuid.toLowerCase());
    }

    public int getCLDM(String uuid) {
        return this.cldm.get(uuid.toLowerCase());
    }
}

