/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.shape;

import am2.api.spell.SpellModifiers;
import am2.api.spell.SpellShape;
import am2.defs.BlockDefs;
import am2.defs.ItemDefs;
import am2.entity.EntitySpellEffect;
import am2.items.ItemSpellBase;
import am2.spell.SpellCastResult;
import am2.utils.SpellUtils;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class Wall
extends SpellShape {
    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.itemOre, 1, 0), BlockDefs.magicWall, Blocks.field_150463_bK, Blocks.field_180407_aO, BlockDefs.magicWall, "E:*", 2500};
    }

    @Override
    public SpellCastResult beginStackStage(ItemSpellBase item, ItemStack stack, EntityLivingBase caster, EntityLivingBase target, World world, double x, double y, double z, EnumFacing side, boolean giveXP, int useCount) {
        if (world.field_72995_K) {
            return SpellCastResult.SUCCESS;
        }
        int radius = SpellUtils.getModifiedInt_Mul(3, stack, caster, (Entity)target, world, SpellModifiers.RADIUS);
        double gravity = SpellUtils.getModifiedDouble_Add(0.0, stack, caster, (Entity)target, world, SpellModifiers.GRAVITY);
        int duration = SpellUtils.getModifiedInt_Mul(100, stack, caster, (Entity)target, world, SpellModifiers.DURATION);
        EntitySpellEffect wall = new EntitySpellEffect(world);
        wall.setRadius(radius);
        wall.setTicksToExist(duration);
        wall.setGravity(gravity);
        wall.SetCasterAndStack(caster, stack);
        wall.func_70107_b(x, y, z);
        wall.setWall(caster.field_70177_z);
        world.func_72838_d((Entity)wall);
        return SpellCastResult.SUCCESS;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.of(SpellModifiers.RADIUS, SpellModifiers.GRAVITY, SpellModifiers.DURATION, SpellModifiers.COLOR, SpellModifiers.TARGET_NONSOLID_BLOCKS);
    }

    @Override
    public boolean isChanneled() {
        return false;
    }

    @Override
    public float manaCostMultiplier(ItemStack spellStack) {
        return 2.5f;
    }

    @Override
    public boolean isTerminusShape() {
        return false;
    }

    @Override
    public boolean isPrincipumShape() {
        return true;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }
}

