/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.shape;

import am2.api.spell.SpellModifiers;
import am2.api.spell.SpellShape;
import am2.defs.BlockDefs;
import am2.defs.ItemDefs;
import am2.items.ItemSpellBase;
import am2.spell.SpellCastResult;
import am2.utils.SpellUtils;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class Rune
extends SpellShape {
    @Override
    public SpellCastResult beginStackStage(ItemSpellBase item, ItemStack stack, EntityLivingBase caster, EntityLivingBase target, World world, double x, double y, double z, EnumFacing side, boolean consumeMBR, int useCount) {
        int procs = SpellUtils.getModifiedInt_Add(1, stack, caster, (Entity)target, world, SpellModifiers.PROCS);
        boolean targetWater = SpellUtils.modifierIsPresent(SpellModifiers.TARGET_NONSOLID_BLOCKS, stack);
        RayTraceResult mop = item.getMovingObjectPosition(caster, world, 8.0, true, targetWater);
        if (mop == null || mop.field_72313_a == RayTraceResult.Type.ENTITY) {
            return SpellCastResult.EFFECT_FAILED;
        }
        if (!BlockDefs.spellRune.placeAt(world, mop.func_178782_a().func_177984_a(), BlockDefs.spellRune.func_176223_P())) {
            return SpellCastResult.EFFECT_FAILED;
        }
        if (!world.field_72995_K) {
            BlockDefs.spellRune.setSpellStack(world, mop.func_178782_a().func_177984_a(), stack);
            BlockDefs.spellRune.setPlacedBy(world, mop.func_178782_a().func_177984_a(), caster);
            BlockDefs.spellRune.setNumTriggers(world, mop.func_178782_a().func_177984_a(), world.func_180495_p(mop.func_178782_a().func_177984_a()), procs);
        }
        return SpellCastResult.SUCCESS;
    }

    @Override
    public boolean isChanneled() {
        return false;
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.BLUE.func_176767_b()), new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.RED.func_176767_b()), new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.WHITE.func_176767_b()), new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.BLACK.func_176767_b()), new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.ORANGE.func_176767_b()), new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.PURPLE.func_176767_b()), new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.YELLOW.func_176767_b())};
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.of(SpellModifiers.TARGET_NONSOLID_BLOCKS, SpellModifiers.PROCS);
    }

    @Override
    public float manaCostMultiplier(ItemStack spellStack) {
        return 1.8f;
    }

    @Override
    public boolean isTerminusShape() {
        return false;
    }

    @Override
    public boolean isPrincipumShape() {
        return true;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }
}

