/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.shape;

import am2.ArsMagica2;
import am2.api.affinity.Affinity;
import am2.api.spell.SpellModifier;
import am2.api.spell.SpellModifiers;
import am2.api.spell.SpellShape;
import am2.defs.ItemDefs;
import am2.entity.EntitySpellProjectile;
import am2.items.ItemSpellBase;
import am2.particles.AMParticle;
import am2.particles.AMParticleDefs;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleLeaveParticleTrail;
import am2.particles.ParticleMoveOnHeading;
import am2.power.PowerTypes;
import am2.spell.SpellCastResult;
import am2.spell.modifier.Colour;
import am2.utils.AffinityShiftUtils;
import am2.utils.SpellUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AoE
extends SpellShape {
    @Override
    public SpellCastResult beginStackStage(ItemSpellBase item, ItemStack stack, EntityLivingBase caster, EntityLivingBase target, World world, double x, double y, double z, EnumFacing side, boolean giveXP, int useCount) {
        double radius = SpellUtils.getModifiedDouble_Add(1.0, stack, caster, (Entity)target, world, SpellModifiers.RADIUS);
        List entities = world.func_72872_a(Entity.class, new AxisAlignedBB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius));
        boolean appliedToAtLeastOneEntity = false;
        for (Entity e : entities) {
            if (e == caster || e instanceof EntitySpellProjectile) continue;
            if (e instanceof EntityDragonPart && ((EntityDragonPart)e).field_70259_a instanceof EntityLivingBase) {
                e = (EntityLivingBase)((EntityDragonPart)e).field_70259_a;
            }
            if (SpellUtils.applyStageToEntity(stack, caster, world, e, giveXP) != SpellCastResult.SUCCESS) continue;
            appliedToAtLeastOneEntity = true;
        }
        BlockPos pos = new BlockPos(x, y, z);
        if (side != null) {
            switch (side) {
                case UP: 
                case DOWN: {
                    if (world.field_72995_K) {
                        this.spawnAoEParticles(stack, caster, world, x + 0.5, y + (double)(side.equals((Object)EnumFacing.DOWN) ? 0.5f : (target != null ? target.func_70047_e() : -2.0f)), z + 0.5, (int)radius);
                    }
                    int gravityMagnitude = SpellUtils.countModifiers(SpellModifiers.GRAVITY, stack);
                    return this.applyStageHorizontal(stack, caster, world, pos, side, (int)Math.floor(radius), gravityMagnitude, giveXP);
                }
                case NORTH: 
                case SOUTH: {
                    if (world.field_72995_K) {
                        this.spawnAoEParticles(stack, caster, world, x + 0.5, y - 1.0, z + 0.5, (int)radius);
                    }
                    return this.applyStageVerticalZ(stack, caster, world, pos, side, (int)Math.floor(radius), giveXP);
                }
                case EAST: 
                case WEST: {
                    if (world.field_72995_K) {
                        this.spawnAoEParticles(stack, caster, world, x + 0.5, y - 1.0, z + 0.5, (int)radius);
                    }
                    return this.applyStageVerticalX(stack, caster, world, pos, side, (int)Math.floor(radius), giveXP);
                }
            }
        } else {
            if (world.field_72995_K) {
                this.spawnAoEParticles(stack, caster, world, x, y - 1.0, z, (int)radius);
            }
            int gravityMagnitude = SpellUtils.countModifiers(SpellModifiers.GRAVITY, stack);
            return this.applyStageHorizontal(stack, caster, world, pos, null, (int)Math.floor(radius), gravityMagnitude, giveXP);
        }
        if (appliedToAtLeastOneEntity) {
            if (world.field_72995_K) {
                this.spawnAoEParticles(stack, caster, world, x, y + 1.0, z, (int)radius);
            }
            return SpellCastResult.SUCCESS;
        }
        return SpellCastResult.EFFECT_FAILED;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.of(SpellModifiers.RADIUS, SpellModifiers.GRAVITY);
    }

    private void spawnAoEParticles(ItemStack stack, EntityLivingBase caster, World world, double x, double y, double z, int radius) {
        String pfxName = AMParticleDefs.getParticleForAffinity(AffinityShiftUtils.getMainShiftForStack(stack));
        float speed = 0.08f * (float)radius;
        int color = 0xFFFFFF;
        if (SpellUtils.modifierIsPresent(SpellModifiers.COLOR, stack)) {
            ArrayList<SpellModifier> mods = SpellUtils.getModifiersForStage(stack, -1);
            for (SpellModifier mod : mods) {
                if (!(mod instanceof Colour)) continue;
                color = (int)mod.getModifier(SpellModifiers.COLOR, null, null, null, stack.func_77978_p());
            }
        }
        for (int i = 0; i < 360; i += ArsMagica2.config.FullGFX() ? 20 : (ArsMagica2.config.LowGFX() ? 40 : 60)) {
            AMParticle effect = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, pfxName, x, y + 1.5, z));
            if (effect == null) continue;
            effect.setIgnoreMaxAge(true);
            effect.AddParticleController(new ParticleMoveOnHeading(effect, i, 0.0, speed, 1, false));
            effect.setRGBColorI(color);
            effect.AddParticleController(new ParticleFadeOut(effect, 1, false).setFadeSpeed(0.05f).setKillParticleOnFinish(true));
            effect.AddParticleController(new ParticleLeaveParticleTrail(effect, pfxName, false, 5, 1, false).addControllerToParticleList(new ParticleFadeOut(effect, 1, false).setFadeSpeed(0.1f).setKillParticleOnFinish(true)).setParticleRGB_I(color).addRandomOffset(0.2f, 0.2f, 0.2f));
        }
    }

    private SpellCastResult applyStageHorizontal(ItemStack stack, EntityLivingBase caster, World world, BlockPos pos, EnumFacing face, int radius, int gravityMagnitude, boolean giveXP) {
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                SpellCastResult result;
                BlockPos lookPos = pos.func_177982_a(i, 0, j);
                if (gravityMagnitude > 0) {
                    for (int searchDist = 0; world.func_175623_d(lookPos) && searchDist < gravityMagnitude; ++searchDist) {
                        pos.func_177977_b();
                    }
                }
                if (world.func_175623_d(lookPos) || (result = SpellUtils.applyStageToGround(stack, caster, world, lookPos, face == null ? EnumFacing.UP : face, lookPos.func_177958_n(), lookPos.func_177956_o(), lookPos.func_177952_p(), giveXP)) == SpellCastResult.SUCCESS) continue;
                return result;
            }
        }
        return SpellCastResult.SUCCESS;
    }

    private SpellCastResult applyStageVerticalX(ItemStack stack, EntityLivingBase caster, World world, BlockPos pos, EnumFacing face, int radius, boolean giveXP) {
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                SpellCastResult result;
                BlockPos lookPos = pos.func_177982_a(0, j, i);
                if (world.func_175623_d(lookPos) || (result = SpellUtils.applyStageToGround(stack, caster, world, lookPos, face, lookPos.func_177958_n(), lookPos.func_177956_o(), lookPos.func_177952_p(), giveXP)) == SpellCastResult.SUCCESS) continue;
                return result;
            }
        }
        return SpellCastResult.SUCCESS;
    }

    private SpellCastResult applyStageVerticalZ(ItemStack stack, EntityLivingBase caster, World world, BlockPos pos, EnumFacing face, int radius, boolean giveXP) {
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                SpellCastResult result;
                BlockPos lookPos = pos.func_177982_a(i, j, 0);
                if (world.func_175623_d(lookPos) || (result = SpellUtils.applyStageToGround(stack, caster, world, lookPos, face, lookPos.func_177958_n(), lookPos.func_177956_o(), lookPos.func_177952_p(), giveXP)) == SpellCastResult.SUCCESS) continue;
                return result;
            }
        }
        return SpellCastResult.SUCCESS;
    }

    @Override
    public boolean isChanneled() {
        return false;
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.itemOre, 1, 3), AffinityShiftUtils.getEssenceForAffinity(Affinity.AIR), String.format("E:%d|%d|%d", PowerTypes.LIGHT.ID(), PowerTypes.NEUTRAL.ID(), PowerTypes.DARK.ID()), 1000, Blocks.field_150335_W};
    }

    @Override
    public float manaCostMultiplier(ItemStack spellStack) {
        int multiplier = 2;
        int radiusMods = 0;
        int stages = SpellUtils.numStages(spellStack);
        for (int i = SpellUtils.currentStage(spellStack); i < stages; ++i) {
            if (!((Object)((Object)SpellUtils.getShapeForStage(spellStack, i))).equals((Object)this)) continue;
            ArrayList<SpellModifier> mods = SpellUtils.getModifiersForStage(spellStack, i);
            for (SpellModifier modifier : mods) {
                if (!modifier.getAspectsModified().contains((Object)SpellModifiers.RADIUS)) continue;
                ++radiusMods;
            }
        }
        return multiplier * (radiusMods + 1);
    }

    @Override
    public boolean isTerminusShape() {
        return true;
    }

    @Override
    public boolean isPrincipumShape() {
        return false;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }
}

