/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.ArsMagica2;
import am2.api.affinity.Affinity;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.defs.ItemDefs;
import am2.extensions.EntityExtension;
import am2.particles.AMParticle;
import am2.particles.ParticleApproachPoint;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Telekinesis
extends SpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos blockPos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return this.doTK_Extrapolated(stack, world, impactX, impactY, impactZ, caster);
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        return this.doTK_Extrapolated(stack, world, target.field_70165_t, target.field_70163_u, target.field_70161_v, caster);
    }

    private boolean doTK_Extrapolated(ItemStack stack, World world, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        double range;
        RayTraceResult mop;
        if (caster instanceof EntityPlayer && (mop = ItemDefs.spell.getMovingObjectPosition(caster, world, range = (double)EntityExtension.For(caster).getTKDistance(), false, false)) == null) {
            impactX = caster.field_70165_t + Math.cos(Math.toRadians(caster.field_70177_z + 90.0f)) * range;
            impactZ = caster.field_70161_v + Math.sin(Math.toRadians(caster.field_70177_z + 90.0f)) * range;
            impactY = caster.field_70163_u + (double)caster.func_70047_e() + -Math.sin(Math.toRadians(caster.field_70125_A)) * range;
        }
        double distance = 16.0;
        int hDist = 3;
        ArrayList entities = new ArrayList();
        entities.addAll(world.func_72872_a(EntityItem.class, new AxisAlignedBB(impactX - distance, impactY - (double)hDist, impactZ - distance, impactX + distance, impactY + (double)hDist, impactZ + distance)));
        entities.addAll(world.func_72872_a(EntityXPOrb.class, new AxisAlignedBB(impactX - distance, impactY - (double)hDist, impactZ - distance, impactX + distance, impactY + (double)hDist, impactZ + distance)));
        for (Entity e : entities) {
            if (e.field_70173_aa < 20) continue;
            Vec3d movement = new Vec3d(e.field_70165_t, e.field_70163_u, e.field_70161_v).func_178788_d(new Vec3d(impactX, impactY, impactZ)).func_72432_b();
            if (world.field_72995_K) continue;
            float factor = 0.15f;
            if (movement.field_72448_b > 0.0) {
                movement = new Vec3d(movement.field_72450_a, 0.0, movement.field_72449_c);
            }
            double x = -(movement.field_72450_a * (double)factor);
            double y = -(movement.field_72448_b * (double)factor);
            double z = -(movement.field_72449_c * (double)factor);
            e.func_70024_g(x, y, z);
            if (Math.abs(e.field_70159_w) > Math.abs(x * 2.0)) {
                e.field_70159_w = x * (e.field_70159_w / e.field_70159_w);
            }
            if (Math.abs(e.field_70181_x) > Math.abs(y * 2.0)) {
                e.field_70181_x = y * (e.field_70181_x / e.field_70181_x);
            }
            if (!(Math.abs(e.field_70179_y) > Math.abs(z * 2.0))) continue;
            e.field_70179_y = z * (e.field_70179_y / e.field_70179_y);
        }
        return true;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 6.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.noneOf(SpellModifiers.class);
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        AMParticle effect;
        double range;
        RayTraceResult mop;
        if (caster instanceof EntityPlayer && (mop = ItemDefs.spell.getMovingObjectPosition(caster, world, range = (double)EntityExtension.For(caster).getTKDistance(), false, false)) == null) {
            x = caster.field_70165_t + Math.cos(Math.toRadians(caster.field_70177_z + 90.0f)) * range;
            z = caster.field_70161_v + Math.sin(Math.toRadians(caster.field_70177_z + 90.0f)) * range;
            y = caster.field_70163_u + (double)caster.func_70047_e() + -Math.sin(Math.toRadians(caster.field_70125_A)) * range;
        }
        if ((effect = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "arcane", x - 0.5 + rand.nextDouble(), y - 0.5 + rand.nextDouble(), z - 0.5 + rand.nextDouble()))) != null) {
            effect.AddParticleController(new ParticleApproachPoint(effect, x, y, z, 0.025f, 0.025f, 1, false));
            effect.setRGBColorF(0.8f, 0.3f, 0.7f);
            if (colorModifier > -1) {
                effect.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
            }
        }
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.ARCANE});
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.PURPLE.func_176767_b()), Blocks.field_150320_F, Blocks.field_150486_ae};
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.001f;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }
}

