/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.api.affinity.Affinity;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.rituals.IRitualInteraction;
import am2.api.rituals.RitualShapeHelper;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.defs.BlockDefs;
import am2.defs.ItemDefs;
import am2.entity.EntityRiftStorage;
import am2.utils.AffinityShiftUtils;
import am2.utils.SpellUtils;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Rift
extends SpellComponent
implements IRitualInteraction {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos blockPos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        if (world.func_180495_p(blockPos).func_177230_c().equals(Blocks.field_150474_ac) && RitualShapeHelper.instance.matchesRitual(this, world, blockPos)) {
            if (!world.field_72995_K) {
                world.func_175698_g(blockPos);
                RitualShapeHelper.instance.consumeReagents(this, world, blockPos);
                RitualShapeHelper.instance.consumeShape(this, world, blockPos);
                EntityItem item = new EntityItem(world);
                item.func_70107_b((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5);
                item.func_92058_a(new ItemStack(BlockDefs.inertSpawner));
                world.func_72838_d((Entity)item);
            }
            return true;
        }
        if (world.field_72995_K) {
            return true;
        }
        EntityRiftStorage storage = new EntityRiftStorage(world);
        int storageLevel = Math.min(1 + SpellUtils.countModifiers(SpellModifiers.BUFF_POWER, stack), 3);
        storage.setStorageLevel(storageLevel);
        switch (blockFace) {
            case UP: {
                storage.func_70107_b((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 1.5, (double)blockPos.func_177952_p() + 0.5);
                break;
            }
            case NORTH: {
                storage.func_70107_b((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() - 1.5);
                break;
            }
            case SOUTH: {
                storage.func_70107_b((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 1.5);
                break;
            }
            case WEST: {
                storage.func_70107_b((double)blockPos.func_177958_n() - 1.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5);
                break;
            }
            case EAST: {
                storage.func_70107_b((double)blockPos.func_177958_n() + 1.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5);
                break;
            }
            default: {
                storage.func_70107_b((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() - 1.5, (double)blockPos.func_177952_p() + 0.5);
            }
        }
        world.func_72838_d((Entity)storage);
        return true;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.noneOf(SpellModifiers.class);
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        return false;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 90.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.NONE});
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.WHITE.func_176767_b()), new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.PURPLE.func_176767_b()), Blocks.field_150486_ae, Items.field_151061_bv};
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.0f;
    }

    @Override
    public MultiblockStructureDefinition getRitualShape() {
        return RitualShapeHelper.instance.corruption;
    }

    @Override
    public ItemStack[] getReagents() {
        return new ItemStack[]{new ItemStack((Item)ItemDefs.mobFocus), AffinityShiftUtils.getEssenceForAffinity(Affinity.ENDER)};
    }

    @Override
    public int getReagentSearchRadius() {
        return 3;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack getResult() {
        return new ItemStack(BlockDefs.inertSpawner);
    }
}

