/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.ArsMagica2;
import am2.api.affinity.Affinity;
import am2.api.math.AMVector3;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.defs.ItemDefs;
import am2.packet.AMNetHandler;
import am2.particles.AMParticle;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleFleePoint;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Repel
extends SpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos blockPos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (target == null) {
            return false;
        }
        if (target == caster) {
            EntityLivingBase source = caster;
            if (target instanceof EntityLivingBase) {
                source = (EntityLivingBase)target;
            }
            List ents = world.func_72872_a(Entity.class, source.func_174813_aQ().func_72314_b(2.0, 2.0, 2.0));
            for (Entity e : ents) {
                this.performRepel(world, caster, e);
            }
            return true;
        }
        this.performRepel(world, caster, target);
        return true;
    }

    private void performRepel(World world, EntityLivingBase caster, Entity target) {
        Vec3d casterPos = new Vec3d(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v);
        Vec3d targetPos = new Vec3d(target.field_70165_t, target.field_70163_u, target.field_70161_v);
        double distance = casterPos.func_72438_d(targetPos) + 0.1;
        Vec3d delta = new Vec3d(targetPos.field_72450_a - casterPos.field_72450_a, targetPos.field_72448_b - casterPos.field_72448_b, targetPos.field_72449_c - casterPos.field_72449_c);
        double dX = delta.field_72450_a / 2.5 / distance;
        double dY = delta.field_72448_b / 2.5 / distance;
        double dZ = delta.field_72449_c / 2.5 / distance;
        if (target instanceof EntityPlayer) {
            AMNetHandler.INSTANCE.sendVelocityAddPacket(world, (EntityLivingBase)((EntityPlayer)target), dX, dY, dZ);
        }
        target.field_70159_w += dX;
        target.field_70181_x += dY;
        target.field_70179_y += dZ;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.noneOf(SpellModifiers.class);
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 5.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < ArsMagica2.config.getGFXLevel() * 2; ++i) {
            AMParticle effect = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "sparkle", x, y, z));
            if (effect == null) continue;
            effect.addRandomOffset(1.0, 2.0, 1.0);
            effect.AddParticleController(new ParticleFleePoint(effect, new AMVector3((Entity)caster).add(new AMVector3(0.0, caster.func_70047_e(), 0.0)).toVec3D(), 0.075f, 3.0, 1, true));
            effect.AddParticleController(new ParticleFadeOut(effect, 1, false).setFadeSpeed(0.05f));
            effect.func_187114_a(20);
            if (colorModifier <= -1) continue;
            effect.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.NONE});
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.WHITE.func_176767_b()), Items.field_151131_as};
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.0f;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }
}

