/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.ArsMagica2;
import am2.api.affinity.Affinity;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.buffs.BuffEffectRegeneration;
import am2.defs.ItemDefs;
import am2.extensions.EntityExtension;
import am2.particles.AMParticle;
import am2.particles.ParticleFloatUpward;
import am2.particles.ParticleOrbitEntity;
import am2.utils.SpellUtils;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Regeneration
extends SpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos blockPos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (target instanceof EntityLivingBase && EntityExtension.For((EntityLivingBase)target).canHeal()) {
            int duration = SpellUtils.getModifiedInt_Mul(600, stack, caster, target, world, SpellModifiers.DURATION);
            if (!world.field_72995_K) {
                ((EntityLivingBase)target).func_70690_d((PotionEffect)new BuffEffectRegeneration(duration, SpellUtils.countModifiers(SpellModifiers.BUFF_POWER, stack)));
            }
            EntityExtension.For((EntityLivingBase)target).setHealCooldown(60);
            return true;
        }
        return false;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 540.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.of(SpellModifiers.BUFF_POWER, SpellModifiers.DURATION);
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 25; ++i) {
            AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "sparkle", x, y - 1.0, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 1.0, 1.0);
            particle.AddParticleController(new ParticleFloatUpward(particle, 0.0f, 0.1f, 1, false));
            particle.AddParticleController(new ParticleOrbitEntity(particle, target, 0.5, 2, false).setIgnoreYCoordinate(true).SetTargetDistance((double)0.3f + rand.nextDouble() * 0.3));
            particle.func_187114_a(20);
            particle.setParticleScale(0.2f);
            particle.setRGBColorF(0.1f, 1.0f, 0.8f);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.LIFE, Affinity.NATURE});
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.BLUE.func_176767_b()), Items.field_151153_ao};
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.05f;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }
}

