/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.ArsMagica2;
import am2.api.affinity.Affinity;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.defs.ItemDefs;
import am2.particles.AMParticle;
import am2.utils.DummyEntityPlayer;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class Plant
extends SpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos pos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        Block soil = world.func_180495_p(pos).func_177230_c();
        InventoryPlayer inventory = DummyEntityPlayer.fromEntityLiving((EntityLivingBase)caster).field_71071_by;
        HashMap<Integer, ItemStack> seeds = this.GetAllSeedsInInventory((IInventory)inventory);
        int currentSlot = 0;
        if (soil != Blocks.field_150350_a && seeds.size() > 0) {
            currentSlot = seeds.keySet().iterator().next();
            ItemStack seedStack = seeds.get(currentSlot);
            IPlantable seed = (IPlantable)seedStack.func_77973_b();
            if (soil != null && soil.canSustainPlant(world.func_180495_p(pos), (IBlockAccess)world, pos, EnumFacing.UP, seed) && world.func_175623_d(pos.func_177984_a())) {
                world.func_175656_a(pos.func_177984_a(), seed.getPlant((IBlockAccess)world, pos));
                --seedStack.field_77994_a;
                if (seedStack.field_77994_a <= 0) {
                    inventory.func_70299_a(currentSlot, null);
                    seeds.remove(currentSlot);
                    if (seeds.size() == 0) {
                        return true;
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.noneOf(SpellModifiers.class);
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        return false;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 80.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 15; ++i) {
            AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "plant", x, y + 1.0, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 1.0, 1.0);
            particle.addVelocity(rand.nextDouble() * 0.2 - 0.1, 0.2f, rand.nextDouble() * 0.2 - 0.1);
            particle.setDontRequireControllers();
            particle.setAffectedByGravity();
            particle.func_187114_a(20);
            particle.setParticleScale(0.1f);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.NATURE});
    }

    private HashMap<Integer, ItemStack> GetAllSeedsInInventory(IInventory inventory) {
        HashMap<Integer, ItemStack> seeds = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            Item item;
            ItemStack slotStack = inventory.func_70301_a(i);
            if (slotStack == null || !((item = slotStack.func_77973_b()) instanceof IPlantable)) continue;
            seeds.put(i, slotStack);
        }
        return seeds;
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.GREEN.func_176767_b()), Items.field_151014_N, new ItemStack(Blocks.field_150345_g, 1, Short.MAX_VALUE), Items.field_151014_N};
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.01f;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }
}

