/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.api.affinity.Affinity;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.defs.ItemDefs;
import am2.utils.InventoryUtilities;
import am2.utils.SpellUtils;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PlaceBlock
extends SpellComponent {
    private static final String KEY_BLOCKID = "PlaceBlockID";
    private static final String KEY_META = "PlaceMeta";

    @Override
    public Object[] getRecipe() {
        return new Object[]{Items.field_151049_t, Items.field_151050_s, Items.field_151051_r, Blocks.field_150486_ae};
    }

    private IBlockState getPlaceBlock(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(KEY_BLOCKID)) {
            return Block.func_149729_e((int)stack.func_77978_p().func_74762_e(KEY_BLOCKID)).func_176203_a(stack.func_77978_p().func_74762_e(KEY_META));
        }
        return null;
    }

    private void setPlaceBlock(ItemStack stack, IBlockState state) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a(KEY_BLOCKID, Block.func_149682_b((Block)state.func_177230_c()));
        stack.func_77978_p().func_74768_a(KEY_META, state.func_177230_c().func_176201_c(state));
        if (!stack.func_77978_p().func_74764_b("Lore")) {
            stack.func_77978_p().func_74782_a("Lore", (NBTBase)new NBTTagList());
        }
        ItemStack blockStack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        NBTTagList tagList = stack.func_77978_p().func_150295_c("Lore", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            String str = tagList.func_150307_f(i);
            if (!str.startsWith(String.format(I18n.func_74838_a((String)"am2.tooltip.placeBlockSpell"), ""))) continue;
            tagList.func_74744_a(i);
        }
        tagList.func_74742_a((NBTBase)new NBTTagString(String.format(I18n.func_74838_a((String)"am2.tooltip.placeBlockSpell"), blockStack.func_82833_r())));
        stack.func_77978_p().func_74782_a("Lore", (NBTBase)tagList);
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.noneOf(SpellModifiers.class);
    }

    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos pos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        if (!(caster instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)caster;
        ItemStack spellStack = player.func_184607_cu();
        if (spellStack == null || spellStack.func_77973_b() != ItemDefs.spell || !SpellUtils.componentIsPresent(spellStack, PlaceBlock.class)) {
            return false;
        }
        IBlockState bd = this.getPlaceBlock(spellStack);
        if (bd != null && !caster.func_70093_af()) {
            if (world.func_175623_d(pos) || !world.func_180495_p(pos).isSideSolid((IBlockAccess)world, pos, blockFace)) {
                blockFace = null;
            }
            if (blockFace != null) {
                pos = pos.func_177971_a(blockFace.func_176730_m());
            }
            if (world.func_175623_d(pos) || !world.func_180495_p(pos).func_185904_a().func_76220_a()) {
                ItemStack searchStack = new ItemStack(bd.func_177230_c(), 1, bd.func_177230_c().func_176201_c(bd));
                if (!world.field_72995_K && (player.field_71075_bZ.field_75098_d || InventoryUtilities.inventoryHasItem((IInventory)player.field_71071_by, searchStack, 1))) {
                    world.func_175656_a(pos, bd);
                    if (!player.field_71075_bZ.field_75098_d) {
                        InventoryUtilities.deductFromInventory((IInventory)player.field_71071_by, searchStack, 1);
                    }
                }
                return true;
            }
        } else if (caster.func_70093_af()) {
            if (!world.field_72995_K && !world.func_175623_d(pos)) {
                this.setPlaceBlock(spellStack, world.func_180495_p(pos));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        return false;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 5.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.EARTH, Affinity.ENDER});
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.05f;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }
}

