/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.ArsMagica2;
import am2.api.affinity.Affinity;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.particles.AMParticle;
import am2.particles.ParticleHoldPosition;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MeltArmor
extends SpellComponent {
    private static final String mmpsNBTTagName = "mmmpsmod";
    private static final String mmpsChargeTagName = "Current Energy";

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack(Blocks.field_150360_v)};
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (target instanceof EntityPlayer && !world.field_72995_K) {
            this.doMeltArmor(caster, ((EntityPlayer)target).field_71071_by.field_70460_b);
            return true;
        }
        return false;
    }

    private void doMeltArmor(EntityLivingBase caster, ItemStack[] armor) {
        double mmpsCharge = this.getMMPSCharge(armor);
        for (ItemStack stack : armor) {
            if (stack == null) continue;
            if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b(mmpsNBTTagName)) {
                stack.func_77972_a((int)Math.ceil((float)stack.func_77973_b().func_77612_l() * 0.25f), caster);
                continue;
            }
            NBTTagCompound subCompound = (NBTTagCompound)stack.func_77978_p().func_74781_a(mmpsNBTTagName);
            double charge = stack.func_77978_p().func_74769_h(mmpsChargeTagName);
            if ((charge -= mmpsCharge * 0.75) < 0.0) {
                charge = 0.0;
            }
            subCompound.func_74780_a(mmpsChargeTagName, charge);
        }
    }

    private double getMMPSCharge(ItemStack[] armor) {
        double total = -1.0;
        for (ItemStack stack : armor) {
            NBTTagCompound subCompound;
            if (stack == null || !stack.func_77942_o() || (subCompound = (NBTTagCompound)stack.func_77978_p().func_74781_a(mmpsNBTTagName)) == null || !subCompound.func_74764_b(mmpsChargeTagName)) continue;
            total += subCompound.func_74769_h(mmpsChargeTagName);
        }
        return total;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 15.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.noneOf(SpellModifiers.class);
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "radiant", x + 0.5, y + 0.5, z + 0.5));
        if (particle != null) {
            particle.AddParticleController(new ParticleHoldPosition(particle, 20, 1, false));
            particle.func_187114_a(20);
            particle.setParticleScale(0.3f);
            particle.setRGBColorF(0.7f, 0.4f, 0.2f);
            particle.SetParticleAlpha(0.1f);
            if (colorModifier > -1) {
                particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
            }
        }
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.FIRE});
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.0f;
    }

    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos blockPos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }
}

