/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.ArsMagica2;
import am2.api.affinity.Affinity;
import am2.api.blocks.MultiblockGroup;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.power.IPowerNode;
import am2.api.rituals.IRitualInteraction;
import am2.api.rituals.RitualShapeHelper;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.buffs.BuffEffectIllumination;
import am2.defs.BlockDefs;
import am2.defs.ItemDefs;
import am2.particles.AMParticle;
import am2.power.PowerNodeRegistry;
import am2.utils.SpellUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Light
extends SpellComponent
implements IRitualInteraction {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos pos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        if (world.func_180495_p(pos).func_177230_c().equals(BlockDefs.obelisk) && RitualShapeHelper.instance.matchesRitual(this, world, pos)) {
            if (!world.field_72995_K) {
                RitualShapeHelper.instance.consumeReagents(this, world, pos);
                RitualShapeHelper.instance.consumeShape(this, world, pos);
                world.func_175656_a(pos, BlockDefs.celestialPrism.func_176223_P());
                PowerNodeRegistry.For(world).registerPowerNode((IPowerNode)world.func_175625_s(pos));
            }
            return true;
        }
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a) {
            blockFace = null;
        }
        if (blockFace != null) {
            pos = pos.func_177972_a(blockFace);
        }
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150350_a) {
            return false;
        }
        if (!world.field_72995_K) {
            world.func_175656_a(pos, BlockDefs.blockMageTorch.func_176223_P());
        }
        return true;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.of(SpellModifiers.COLOR);
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (target instanceof EntityLivingBase) {
            int duration = SpellUtils.getModifiedInt_Mul(600, stack, caster, target, world, SpellModifiers.DURATION);
            if (!world.field_72995_K) {
                ((EntityLivingBase)target).func_70690_d((PotionEffect)new BuffEffectIllumination(duration, SpellUtils.countModifiers(SpellModifiers.BUFF_POWER, stack)));
            }
            return true;
        }
        return false;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 50.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 5; ++i) {
            AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "sparkle2", x, y, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 0.5, 1.0);
            particle.addVelocity(rand.nextDouble() * 0.2 - 0.1, rand.nextDouble() * 0.2, rand.nextDouble() * 0.2 - 0.1);
            particle.setAffectedByGravity();
            particle.setDontRequireControllers();
            particle.func_187114_a(5);
            particle.setParticleScale(0.1f);
            particle.setRGBColorF(0.6f, 0.2f, 0.8f);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.NONE});
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.WHITE.func_176767_b()), BlockDefs.cerublossom, Blocks.field_150478_aa, BlockDefs.vinteumTorch};
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.01f;
    }

    @Override
    public MultiblockStructureDefinition getRitualShape() {
        MultiblockStructureDefinition newDef = new MultiblockStructureDefinition("celestialPurification");
        newDef.groups = Lists.newArrayList(RitualShapeHelper.instance.purification.groups);
        MultiblockGroup obelisk = new MultiblockGroup("obelisk", Lists.newArrayList((Object[])new IBlockState[]{BlockDefs.obelisk.func_176223_P()}), true);
        obelisk.addBlock(new BlockPos(0, 0, 0));
        newDef.addGroup(obelisk, new MultiblockGroup[0]);
        return newDef;
    }

    @Override
    public ItemStack[] getReagents() {
        return new ItemStack[]{new ItemStack((Item)ItemDefs.itemOre, 1, 3), new ItemStack((Item)ItemDefs.manaFocus)};
    }

    @Override
    public int getReagentSearchRadius() {
        return 3;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack getResult() {
        return new ItemStack(BlockDefs.celestialPrism);
    }
}

