/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.ArsMagica2;
import am2.api.affinity.Affinity;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.defs.ItemDefs;
import am2.packet.AMNetHandler;
import am2.particles.AMParticle;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleMoveOnHeading;
import am2.utils.SpellUtils;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Knockback
extends SpellComponent {
    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (target instanceof EntityLivingBase) {
            double angle;
            double speed = 1.5;
            speed = SpellUtils.getModifiedDouble_Add(speed, stack, caster, target, world, SpellModifiers.VELOCITY_ADDED);
            double vertSpeed = 0.325;
            EntityLivingBase curEntity = (EntityLivingBase)target;
            double deltaZ = curEntity.field_70161_v - caster.field_70161_v;
            double deltaX = curEntity.field_70165_t - caster.field_70165_t;
            double radians = angle = Math.atan2(deltaZ, deltaX);
            if (curEntity instanceof EntityPlayer) {
                AMNetHandler.INSTANCE.sendVelocityAddPacket(world, curEntity, speed * Math.cos(radians), vertSpeed, speed * Math.sin(radians));
            } else {
                curEntity.field_70159_w += speed * Math.cos(radians);
                curEntity.field_70179_y += speed * Math.sin(radians);
                curEntity.field_70181_x += vertSpeed;
            }
            return true;
        }
        return false;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.of(SpellModifiers.VELOCITY_ADDED);
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 60.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 25; ++i) {
            AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "sparkle", x, y, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 2.0, 1.0);
            double dx = caster.field_70165_t - target.field_70165_t;
            double dz = caster.field_70161_v - target.field_70161_v;
            double angle = Math.toDegrees(Math.atan2(-dz, -dx));
            particle.AddParticleController(new ParticleMoveOnHeading(particle, angle, 0.0, 0.1 + rand.nextDouble() * 0.5, 1, false));
            particle.AddParticleController(new ParticleFadeOut(particle, 1, false).setFadeSpeed(0.05f));
            particle.func_187114_a(20);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.AIR, Affinity.WATER, Affinity.EARTH});
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.YELLOW.func_176767_b()), Blocks.field_150331_J};
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.01f;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }

    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos blockPos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }
}

