/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.ArsMagica2;
import am2.api.affinity.Affinity;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.rituals.IRitualInteraction;
import am2.api.rituals.RitualShapeHelper;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.defs.ItemDefs;
import am2.particles.AMParticle;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleFloatUpward;
import am2.particles.ParticleOrbitPoint;
import am2.utils.SpellUtils;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Invisiblity
extends SpellComponent
implements IRitualInteraction {
    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (target instanceof EntityLivingBase) {
            int duration = SpellUtils.getModifiedInt_Mul(600, stack, caster, target, world, SpellModifiers.DURATION);
            if (RitualShapeHelper.instance.matchesRitual(this, world, target.func_180425_c())) {
                duration += 3600 * (SpellUtils.countModifiers(SpellModifiers.BUFF_POWER, stack) + 1);
                RitualShapeHelper.instance.consumeReagents(this, world, target.func_180425_c());
            }
            if (!world.field_72995_K) {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(Potion.func_180142_b((String)new ResourceLocation("invisibility").toString()), duration, SpellUtils.countModifiers(SpellModifiers.BUFF_POWER, stack)));
            }
            return true;
        }
        return false;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 80.0f;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.of(SpellModifiers.DURATION, SpellModifiers.BUFF_POWER);
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 25; ++i) {
            AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "ember", x, y - 1.0, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 1.0, 1.0);
            particle.AddParticleController(new ParticleFloatUpward(particle, 0.0f, 0.1f, 1, false));
            particle.AddParticleController(new ParticleOrbitPoint(particle, x, y, z, 2, false).SetOrbitSpeed(0.5).setIgnoreYCoordinate(true).SetTargetDistance((double)0.3f + rand.nextDouble() * 0.3));
            particle.AddParticleController(new ParticleFadeOut(particle, 3, false).setFadeSpeed(0.05f).setKillParticleOnFinish(true));
            particle.func_187114_a(20);
            particle.setParticleScale(0.1f);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.ARCANE});
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.BLACK.func_176767_b()), new ItemStack((Item)ItemDefs.itemOre, 1, 2), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185236_h)};
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.05f;
    }

    @Override
    public MultiblockStructureDefinition getRitualShape() {
        return RitualShapeHelper.instance.hourglass;
    }

    @Override
    public ItemStack[] getReagents() {
        return new ItemStack[]{new ItemStack(Items.field_151061_bv)};
    }

    @Override
    public int getReagentSearchRadius() {
        return 3;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }

    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos blockPos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack getResult() {
        return null;
    }
}

