/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.ArsMagica2;
import am2.api.affinity.Affinity;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.blocks.BlockAMFlower;
import am2.defs.BlockDefs;
import am2.defs.ItemDefs;
import am2.particles.AMParticle;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleFloatUpward;
import am2.particles.ParticleOrbitPoint;
import am2.utils.DummyEntityPlayer;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Grow
extends SpellComponent {
    private static final ArrayList<BlockAMFlower> growableAMflowers = new ArrayList<BlockAMFlower>(Arrays.asList(BlockDefs.cerublossom, BlockDefs.desertNova, BlockDefs.wakebloom, BlockDefs.aum, BlockDefs.tarmaRoot));

    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos pos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        IGrowable igrowable;
        IBlockState block = world.func_180495_p(pos);
        BonemealEvent event = new BonemealEvent(DummyEntityPlayer.fromEntityLiving(caster), world, pos, world.func_180495_p(pos));
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            return true;
        }
        if (world.field_73012_v.nextInt(100) < 3 && block.func_185915_l()) {
            Collections.shuffle(growableAMflowers);
            for (BlockAMFlower flower : growableAMflowers) {
                if (!flower.canGrowOn(world, pos.func_177984_a())) continue;
                if (!world.field_72995_K) {
                    world.func_175656_a(pos.func_177984_a(), flower.func_176223_P());
                }
                return true;
            }
        }
        if (block.func_177230_c() instanceof BlockMushroom) {
            if (!world.field_72995_K && world.field_73012_v.nextInt(10) < 1) {
                ((BlockMushroom)block.func_177230_c()).func_176474_b(world, world.field_73012_v, pos, block);
            }
            return true;
        }
        if (block.func_177230_c() == Blocks.field_150355_j && world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
            if (!world.field_72995_K && world.field_73012_v.nextInt(100) < 3) {
                world.func_175656_a(pos.func_177984_a(), BlockDefs.wakebloom.func_176223_P());
            }
            return true;
        }
        if (block.func_177230_c() == Blocks.field_150329_H && Blocks.field_150329_H.func_180671_f(world, pos, Blocks.field_150329_H.func_176223_P())) {
            if (!world.field_72995_K && world.field_73012_v.nextInt(10) < 2) {
                world.func_175656_a(pos, Blocks.field_150329_H.func_176223_P());
            }
            return true;
        }
        if (block.func_177230_c() == Blocks.field_150330_I && Blocks.field_150330_I.func_180671_f(world, pos, Blocks.field_150330_I.func_176223_P())) {
            if (!world.field_72995_K && world.field_73012_v.nextInt(10) < 2) {
                world.func_175656_a(pos, Blocks.field_150330_I.func_176223_P());
            }
            return true;
        }
        if (block instanceof IGrowable && (igrowable = (IGrowable)block).func_176473_a(world, pos, block, world.field_72995_K)) {
            if (!world.field_72995_K && world.field_73012_v.nextInt(10) < 3 && igrowable.func_180670_a(world, world.field_73012_v, pos, block)) {
                igrowable.func_176474_b(world, world.field_73012_v, pos, block);
            }
            return true;
        }
        return true;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.noneOf(SpellModifiers.class);
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        return false;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 17.4f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 25; ++i) {
            AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "plant", x + 0.5, y + 1.0, z + 0.5));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 1.0, 1.0);
            particle.AddParticleController(new ParticleFloatUpward(particle, 0.0f, 0.1f, 1, false));
            particle.AddParticleController(new ParticleOrbitPoint(particle, x + 0.5, y + 0.5, z + 0.5, 2, false).setIgnoreYCoordinate(true).SetOrbitSpeed(0.1f).SetTargetDistance((double)0.3f + rand.nextDouble() * 0.3));
            particle.AddParticleController(new ParticleFadeOut(particle, 1, false).setFadeSpeed(0.05f).setKillParticleOnFinish(true));
            particle.func_187114_a(20);
            particle.setParticleScale(0.1f);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.NATURE});
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.GREEN.func_176767_b()), new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.WHITE.func_176767_b())};
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.02f;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }
}

