/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.api.affinity.Affinity;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.defs.BlockDefs;
import am2.defs.ItemDefs;
import am2.entity.EntityThrownRock;
import am2.utils.AffinityShiftUtils;
import am2.utils.SpellUtils;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FallingStar
extends SpellComponent {
    @Override
    public Object[] getRecipe() {
        return new Object[]{AffinityShiftUtils.getEssenceForAffinity(Affinity.ARCANE), new ItemStack((Item)ItemDefs.itemOre, 1, 6), AffinityShiftUtils.getEssenceForAffinity(Affinity.ARCANE), BlockDefs.manaBattery, Items.field_151129_at};
    }

    private boolean spawnStar(ItemStack spellStack, EntityLivingBase caster, Entity target, World world, double x, double y, double z) {
        List rocks = world.func_72872_a(EntityThrownRock.class, new AxisAlignedBB(x - 10.0, y - 10.0, z - 10.0, x + 10.0, y + 10.0, z + 10.0));
        int damageMultitplier = SpellUtils.getModifiedInt_Mul(15, spellStack, caster, target, world, SpellModifiers.DAMAGE);
        for (EntityThrownRock rock : rocks) {
            if (!rock.getIsShootingStar()) continue;
            return false;
        }
        if (!world.field_72995_K) {
            EntityThrownRock star = new EntityThrownRock(world);
            star.func_70107_b(x, world.func_72940_L(), z);
            star.setShootingStar(2 * damageMultitplier);
            star.setThrowingEntity(caster);
            star.setSpellStack(spellStack.func_77946_l());
            world.func_72838_d((Entity)star);
        }
        return true;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.of(SpellModifiers.DAMAGE, SpellModifiers.COLOR);
    }

    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos pos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return this.spawnStar(stack, caster, (Entity)caster, world, impactX, impactY + 50.0, impactZ);
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        return this.spawnStar(stack, caster, target, world, target.field_70165_t, target.field_70163_u + 50.0, target.field_70161_v);
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 400.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.ARCANE});
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.05f;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }
}

