/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.ArsMagica2;
import am2.api.affinity.Affinity;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.buffs.BuffEffect;
import am2.defs.ItemDefs;
import am2.defs.PotionEffectsDefs;
import am2.extensions.EntityExtension;
import am2.particles.AMParticle;
import am2.particles.ParticleOrbitEntity;
import am2.utils.EntityUtils;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Dispel
extends SpellComponent {
    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (!(target instanceof EntityLivingBase)) {
            return false;
        }
        if (EntityUtils.isSummon((EntityLivingBase)target) && EntityUtils.getOwner((EntityLivingBase)target) == caster.func_145782_y()) {
            target.func_70097_a(DamageSource.field_76376_m, 50000.0f);
            return true;
        }
        ArrayList<Potion> effectsToRemove = new ArrayList<Potion>();
        int magnitudeLeft = 6;
        Iterator iter = ((EntityLivingBase)target).func_70651_bq().iterator();
        while (iter.hasNext()) {
            Potion potion = ((PotionEffect)iter.next()).func_188419_a();
            PotionEffect pe = ((EntityLivingBase)target).func_70660_b(potion);
            int magnitudeCost = pe.func_76458_c();
            if (magnitudeLeft < magnitudeCost) continue;
            magnitudeLeft -= magnitudeCost;
            if (pe instanceof BuffEffect && !world.field_72995_K) {
                ((BuffEffect)pe).stopEffect((EntityLivingBase)target);
            }
            effectsToRemove.add(potion);
        }
        if (effectsToRemove.size() == 0 && EntityExtension.For((EntityLivingBase)target).getCurrentSummons() == 0) {
            return false;
        }
        if (!world.field_72995_K) {
            this.removePotionEffects((EntityLivingBase)target, effectsToRemove);
        }
        return true;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.noneOf(SpellModifiers.class);
    }

    private void removePotionEffects(EntityLivingBase target, List<Potion> effectsToRemove) {
        for (Potion i : effectsToRemove) {
            if ((i == PotionEffectsDefs.flight || i == PotionEffectsDefs.levitation) && target instanceof EntityPlayer && target.func_70644_a(PotionEffectsDefs.flight)) {
                ((EntityPlayer)target).field_71075_bZ.field_75100_b = false;
                ((EntityPlayer)target).field_71075_bZ.field_75101_c = false;
            }
            target.func_184589_d(i);
        }
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 200.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 25; ++i) {
            AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "sparkle2", x, y, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 2.0, 1.0);
            particle.AddParticleController(new ParticleOrbitEntity(particle, target, 0.1f + rand.nextFloat() * 0.1f, 1, false));
            if (rand.nextBoolean()) {
                particle.setRGBColorF(0.7f, 0.1f, 0.7f);
            }
            particle.func_187114_a(20);
            particle.setParticleScale(0.1f);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.NONE});
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.PURPLE.func_176767_b()), new ItemStack((Item)ItemDefs.itemOre, 1, 6), new ItemStack((Item)ItemDefs.itemOre, 1, 5), Items.field_151117_aB};
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.0f;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }

    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos blockPos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }
}

