/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.ArsMagica2;
import am2.api.affinity.Affinity;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.rituals.IRitualInteraction;
import am2.api.rituals.RitualShapeHelper;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.buffs.BuffEffectCharmed;
import am2.defs.ItemDefs;
import am2.defs.PotionEffectsDefs;
import am2.extensions.EntityExtension;
import am2.particles.AMParticle;
import am2.particles.ParticleFloatUpward;
import am2.utils.AffinityShiftUtils;
import am2.utils.EntityUtils;
import am2.utils.SpellUtils;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Charm
extends SpellComponent
implements IRitualInteraction {
    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.RED.func_176767_b()), AffinityShiftUtils.getEssenceForAffinity(Affinity.LIFE), new ItemStack((Item)ItemDefs.crystalPhylactery, 1, 0)};
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (!(target instanceof EntityCreature) || ((EntityCreature)target).func_70644_a(PotionEffectsDefs.charme) || EntityUtils.isSummon((EntityLivingBase)((EntityCreature)target))) {
            return false;
        }
        int duration = SpellUtils.getModifiedInt_Mul(600, stack, caster, target, world, SpellModifiers.DURATION);
        if (RitualShapeHelper.instance.matchesRitual(this, world, target.func_180425_c())) {
            duration += 3600 * (SpellUtils.countModifiers(SpellModifiers.BUFF_POWER, stack) + 1);
            RitualShapeHelper.instance.consumeReagents(this, world, target.func_180425_c());
        }
        if (target instanceof EntityAnimal) {
            ((EntityAnimal)target).func_146082_f(null);
            return true;
        }
        if (EntityExtension.For(caster).getCanHaveMoreSummons()) {
            if (caster instanceof EntityPlayer) {
                if (target instanceof EntityCreature) {
                    BuffEffectCharmed charmBuff = new BuffEffectCharmed(duration, 1);
                    charmBuff.setCharmer(caster);
                    ((EntityCreature)target).func_70690_d((PotionEffect)charmBuff);
                }
                return true;
            }
            if (caster instanceof EntityLiving) {
                if (target instanceof EntityCreature) {
                    BuffEffectCharmed charmBuff = new BuffEffectCharmed(duration, 2);
                    charmBuff.setCharmer(caster);
                    ((EntityCreature)target).func_70690_d((PotionEffect)charmBuff);
                }
                return true;
            }
        } else {
            if (caster instanceof EntityPlayer) {
                ((EntityPlayer)caster).func_145747_a((ITextComponent)new TextComponentString("You cannot have any more summons."));
            }
            return true;
        }
        return false;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.of(SpellModifiers.DURATION);
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 300.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 10; ++i) {
            AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "heart", x, y, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 2.0, 1.0);
            particle.AddParticleController(new ParticleFloatUpward(particle, 0.0f, 0.05f + rand.nextFloat() * 0.1f, 1, false));
            particle.func_187114_a(20);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.LIFE});
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.1f;
    }

    @Override
    public MultiblockStructureDefinition getRitualShape() {
        return RitualShapeHelper.instance.hourglass;
    }

    @Override
    public ItemStack[] getReagents() {
        return new ItemStack[]{new ItemStack(Items.field_151015_O), new ItemStack(Items.field_151014_N), new ItemStack(Items.field_151172_bF)};
    }

    @Override
    public int getReagentSearchRadius() {
        return 3;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }

    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos blockPos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack getResult() {
        return null;
    }
}

