/*
 * Decompiled with CFR 0.152.
 */
package am2.power;

import java.util.ArrayList;
import net.minecraft.util.text.TextFormatting;

public class PowerTypes {
    private static int nextID = 1;
    private static ArrayList<PowerTypes> types = new ArrayList();
    public static final PowerTypes NONE = new PowerTypes("None");
    public static final PowerTypes LIGHT = new PowerTypes("Light", "\u00a7b", 1.25f, 1.0f, 43775);
    public static final PowerTypes NEUTRAL = new PowerTypes("Neutral", "\u00a71", 1.0f, 1.0f, 170);
    public static final PowerTypes DARK = new PowerTypes("Dark", "\u00a74", 0.75f, 1.0f, 0x770000);
    private int ID;
    private String name;
    private String chatColor;
    private int color;
    private float inputCostMultiplier;
    private float outputMultiplier;

    private PowerTypes(String name) {
        this.ID = 0;
        this.name = name;
        this.chatColor = TextFormatting.WHITE.toString();
        this.color = 0xFFFFFF;
        this.inputCostMultiplier = 1.0f;
        this.outputMultiplier = 1.0f;
    }

    public PowerTypes(String name, String chatColor, float inputCostMultiplier, float outputMultiplier, int color) {
        this.ID = nextID;
        nextID *= 2;
        this.name = name;
        this.chatColor = chatColor;
        this.color = color;
        this.inputCostMultiplier = inputCostMultiplier;
        this.outputMultiplier = outputMultiplier;
        types.add(this);
    }

    public int ID() {
        return this.ID;
    }

    public String name() {
        return this.name.toLowerCase();
    }

    public static ArrayList<PowerTypes> all() {
        return types;
    }

    public int getColor() {
        return this.color;
    }

    public String getChatColor() {
        return this.chatColor;
    }

    public float getInputCostMultiplier() {
        return this.inputCostMultiplier;
    }

    public float getOutputMultiplier() {
        return this.outputMultiplier;
    }

    public static PowerTypes getByID(int integer) {
        for (PowerTypes type : PowerTypes.all()) {
            if (type.ID != integer) continue;
            return type;
        }
        return NONE;
    }
}

